/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v7.reaction;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v7.IdentityRefV7;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractReactionV7<T extends AbstractReactionV7<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<AbstractReactionV7<?>, IdentityRefV7> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String EMOJI_NAME = "emoji";
    public static final Column.ObjectColumn<AbstractReactionV7<?>, String> EMOJI = new Column.ObjectColumn("emoji", true);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractReactionV7<?>> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_sender", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES identity_ref_table(gen_id)")
    protected IdentityRefV7 fkSender;
    @DatabaseField(columnName="emoji", dataType=DataType.STRING)
    protected String emoji;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public AbstractReactionV7() {
    }

    protected AbstractReactionV7(long genId) {
        super(genId);
    }

    protected AbstractReactionV7(long genId, IdentityRefV7 sender, String emoji, long timestamp) {
        super(genId);
        this.fkSender = sender;
        this.emoji = emoji;
        this.timestamp = timestamp;
    }

    public Id<IdentityRefV7> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("AbstractReaction[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractReactionV7 casted = (AbstractReactionV7)this.getClazz().cast(obj);
        return Objects.equals(this.fkSender, casted.fkSender) && Objects.equals(this.emoji, casted.emoji) && this.timestamp == casted.timestamp;
    }
}

