/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v7.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v7.ContactRefV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.DiscussionV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.LocationV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.ephemerality.InboundMessageEphemeralInfoV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.message.AbstractUserMessageV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.message.MessageRefV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.message.ReceivedMessageV7;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="inbound_message_table")
public class InboundMessageV7
extends ReceivedMessageV7<InboundMessageV7>
implements Table {
    public static final String TABLE_NAME = "inbound_message_table";
    private static final String FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_inbound_message_ephemeral_info";
    public static final Column.ForeignColumn<InboundMessageV7, InboundMessageEphemeralInfoV7> FK_INBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_inbound_message_ephemeral_info", true);
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<InboundMessageV7, ContactRefV7> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<InboundMessageV7, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String BOXED_NAME = "boxed";
    public static final Column.booleanColumn<InboundMessageV7> BOXED = new Column.booleanColumn("boxed");
    @DatabaseField(columnName="fk_inbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message_ephemeral_info REFERENCES inbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageEphemeralInfoV7 fkInboundMessageEphemeralInfo;
    @DatabaseField(columnName="fk_sender", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES contact_ref_table(gen_id)")
    protected ContactRefV7 fkSender;
    @DatabaseField(columnName="status", index=true, canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="boxed", dataType=DataType.BOOLEAN)
    protected boolean boxed;

    public InboundMessageV7() {
    }

    public InboundMessageV7(long genId) {
        super(genId);
    }

    public InboundMessageV7(long genId, DiscussionV7 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV7 replyTo, LocationV7 location, AbstractUserMessageV7.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageV7.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageV7.EditionStatus editionStatus, boolean forwarded, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, InboundMessageEphemeralInfoV7 inboundMessageEphemeralInfo, ContactRefV7 sender, Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount);
        this.fkInboundMessageEphemeralInfo = inboundMessageEphemeralInfo;
        this.fkSender = sender;
        this.status = status;
        this.boxed = boxed;
    }

    public Optional<Id<InboundMessageEphemeralInfoV7>> getInboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkInboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRefV7> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
    }

    @Override
    public String toString() {
        return String.format("InboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InboundMessageV7 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkInboundMessageEphemeralInfo, casted.fkInboundMessageEphemeralInfo) && Objects.equals(this.fkSender, casted.fkSender) && this.status == casted.status && this.boxed == casted.boxed;
    }

    @Override
    protected Class<InboundMessageV7> getClazz() {
        return InboundMessageV7.class;
    }

    public static enum Status implements IComparable<Status>
    {
        UNREAD,
        READ;

    }
}

