/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v7.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v7.DiscussionV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.LocationV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.message.AbstractMessageV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.message.MessageRefV7;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractUserMessageV7<T extends AbstractUserMessageV7<T>>
extends AbstractMessageV7<T>
implements Table {
    private static final String BODY_NAME = "body";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, String> BODY = new Column.ObjectColumn("body", true);
    private static final String FK_REPLY_TO_NAME = "fk_reply_to";
    public static final Column.ForeignColumn<AbstractUserMessageV7<?>, MessageRefV7> FK_REPLY_TO = new Column.ForeignColumn("fk_reply_to", true);
    private static final String FK_LOCATION_NAME = "fk_location";
    public static final Column.ForeignColumn<AbstractUserMessageV7<?>, LocationV7> FK_LOCATION = new Column.ForeignColumn("fk_location", true);
    private static final String WIPE_STATUS_NAME = "wipe_status";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, WipeStatus> WIPE_STATUS = new Column.ObjectColumn("wipe_status", false);
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String TOTAL_ATTACHMENT_COUNT_NAME = "total_attachment_count";
    public static final Column.intColumn<AbstractUserMessageV7<?>> TOTAL_ATTACHMENT_COUNT = new Column.intColumn("total_attachment_count");
    private static final String IMAGE_COUNT_NAME = "image_count";
    public static final Column.intColumn<AbstractUserMessageV7<?>> IMAGE_COUNT = new Column.intColumn("image_count");
    private static final String LINK_PREVIEW_KIND_NAME = "link_preview_kind";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, LinkPreviewKind> LINK_PREVIEW_KIND = new Column.ObjectColumn("link_preview_kind", false);
    private static final String LINK_PREVIEW_DESCRIPTION_NAME = "link_preview_description";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, String> LINK_PREVIEW_DESCRIPTION = new Column.ObjectColumn("link_preview_description", true);
    private static final String LINK_PREVIEW_IMAGE_WIDTH_NAME = "link_preview_image_width";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, Double> LINK_PREVIEW_IMAGE_WIDTH = new Column.ObjectColumn("link_preview_image_width", true);
    private static final String EDITION_STATUS_NAME = "edition_status";
    public static final Column.ObjectColumn<AbstractUserMessageV7<?>, EditionStatus> EDITION_STATUS = new Column.ObjectColumn("edition_status", false);
    private static final String FORWARDED_NAME = "forwarded";
    public static final Column.booleanColumn<AbstractUserMessageV7<?>> FORWARDED = new Column.booleanColumn("forwarded");
    @DatabaseField(columnName="body", dataType=DataType.STRING)
    protected String body;
    @DatabaseField(columnName="fk_reply_to", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_reply_to REFERENCES message_ref_table(gen_id) ON DELETE SET NULL")
    protected MessageRefV7 fkReplyTo;
    @DatabaseField(columnName="fk_location", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_location REFERENCES location_table(gen_id) ON DELETE SET NULL")
    protected LocationV7 fkLocation;
    @DatabaseField(columnName="wipe_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected WipeStatus wipeStatus;
    @DatabaseField(columnName="sender_thread_identifier", canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="total_attachment_count", dataType=DataType.INTEGER)
    protected int totalAttachmentCount;
    @DatabaseField(columnName="image_count", dataType=DataType.INTEGER)
    protected int imageCount;
    @DatabaseField(columnName="link_preview_kind", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected LinkPreviewKind linkPreviewKind;
    @DatabaseField(columnName="link_preview_description", dataType=DataType.STRING)
    protected String linkPreviewDescription;
    @DatabaseField(columnName="link_preview_image_width", dataType=DataType.DOUBLE_OBJ)
    protected Double linkPreviewImageWidth;
    @DatabaseField(columnName="edition_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected EditionStatus editionStatus;
    @DatabaseField(columnName="forwarded", dataType=DataType.BOOLEAN)
    protected boolean forwarded;

    public AbstractUserMessageV7() {
    }

    protected AbstractUserMessageV7(long genId) {
        super(genId);
    }

    protected AbstractUserMessageV7(long genId, DiscussionV7 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV7 replyTo, LocationV7 location, WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, EditionStatus editionStatus, boolean forwarded) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp);
        this.body = body;
        this.fkReplyTo = replyTo;
        this.fkLocation = location;
        this.wipeStatus = wipeStatus;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.totalAttachmentCount = totalAttachmentCount;
        this.imageCount = imageCount;
        this.linkPreviewKind = linkPreviewKind;
        this.linkPreviewDescription = linkPreviewDescription;
        this.linkPreviewImageWidth = linkPreviewImageWidth;
        this.editionStatus = editionStatus;
        this.forwarded = forwarded;
    }

    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public void setBody(Optional<String> body) {
        this.body = body.orElse(null);
    }

    public Optional<Id<MessageRefV7>> getReplyToId() {
        return Optional.ofNullable(this.fkReplyTo).map(AbstractTableGenerated::getItemId);
    }

    public void setReplyTo(Optional<MessageRefV7> fkReplyTo) {
        this.fkReplyTo = fkReplyTo.orElse(null);
    }

    public Optional<Id<LocationV7>> getLocationId() {
        return Optional.ofNullable(this.fkLocation).map(AbstractTableGenerated::getItemId);
    }

    public WipeStatus getWipeStatus() {
        return this.wipeStatus;
    }

    public void setWipeStatus(WipeStatus wipeStatus) {
        this.wipeStatus = wipeStatus;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public int getTotalAttachmentCount() {
        return this.totalAttachmentCount;
    }

    public void setTotalAttachmentCount(int totalAttachmentCount) {
        this.totalAttachmentCount = totalAttachmentCount;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int imageCount) {
        this.imageCount = imageCount;
    }

    public LinkPreviewKind getLinkPreviewKind() {
        return this.linkPreviewKind;
    }

    public void setLinkPreviewKind(LinkPreviewKind linkPreviewKind) {
        this.linkPreviewKind = linkPreviewKind;
    }

    public Optional<String> getLinkPreviewDescription() {
        return Optional.ofNullable(this.linkPreviewDescription);
    }

    public void setLinkPreviewDescription(Optional<String> linkPreviewDescription) {
        this.linkPreviewDescription = linkPreviewDescription.orElse(null);
    }

    public Optional<Double> getLinkPreviewImageWidth() {
        return Optional.ofNullable(this.linkPreviewImageWidth);
    }

    public void setLinkPreviewImageWidth(Optional<Double> linkPreviewImageWidth) {
        this.linkPreviewImageWidth = linkPreviewImageWidth.orElse(null);
    }

    public EditionStatus getEditionStatus() {
        return this.editionStatus;
    }

    public void setEditionStatus(EditionStatus editionStatus) {
        this.editionStatus = editionStatus;
    }

    public boolean isForwarded() {
        return this.forwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.forwarded = forwarded;
    }

    @Override
    public String toString() {
        return String.format("AbstractUserMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractUserMessageV7 casted = (AbstractUserMessageV7)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.body, casted.body) && Objects.equals(this.fkReplyTo, casted.fkReplyTo) && Objects.equals(this.fkLocation, casted.fkLocation) && this.wipeStatus == casted.wipeStatus && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && this.totalAttachmentCount == casted.totalAttachmentCount && this.imageCount == casted.imageCount && this.linkPreviewKind == casted.linkPreviewKind && Objects.equals(this.linkPreviewDescription, casted.linkPreviewDescription) && Objects.equals(this.linkPreviewImageWidth, casted.linkPreviewImageWidth) && this.editionStatus == casted.editionStatus && this.forwarded == casted.forwarded;
    }

    public static enum WipeStatus implements IComparable<WipeStatus>
    {
        NONE,
        WIPE_ON_READ,
        WIPED,
        REMOTE_DELETED;

    }

    public static enum LinkPreviewKind implements IComparable<LinkPreviewKind>
    {
        NONE,
        DOWNLOADING,
        PARTIAL,
        FULL;

    }

    public static enum EditionStatus implements IComparable<EditionStatus>
    {
        NONE,
        UNSEEN,
        SEEN;

    }
}

