/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v6.metadata;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v6.IdentityRefV6;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractMessageMetadataV6<T extends AbstractMessageMetadataV6<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractMessageMetadataV6<?>> TIMESTAMP = new Column.longColumn("timestamp");
    private static final String FK_DELETER_NAME = "fk_deleter";
    public static final Column.ForeignColumn<AbstractMessageMetadataV6<?>, IdentityRefV6> FK_DELETER = new Column.ForeignColumn("fk_deleter", true);
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;
    @DatabaseField(columnName="fk_deleter", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_deleter REFERENCES identity_ref_table(gen_id) ON DELETE SET NULL")
    protected IdentityRefV6 fkDeleter;

    public AbstractMessageMetadataV6() {
    }

    protected AbstractMessageMetadataV6(long genId) {
        super(genId);
    }

    protected AbstractMessageMetadataV6(long genId, long timestamp, IdentityRefV6 deleter) {
        super(genId);
        this.timestamp = timestamp;
        this.fkDeleter = deleter;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<Id<IdentityRefV6>> getDeleterId() {
        return Optional.ofNullable(this.fkDeleter).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("AbstractMessageMetadata[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractMessageMetadataV6 casted = (AbstractMessageMetadataV6)this.getClazz().cast(obj);
        return this.timestamp == casted.timestamp && Objects.equals(this.fkDeleter, casted.fkDeleter);
    }
}

