/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v5.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v5.DiscussionV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.InboundMessageV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.OutboundMessageV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.OwnedMessageV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="message_ref_table")
public class MessageRefV5
extends AbstractTableGenerated<MessageRefV5>
implements Table {
    public static final String TABLE_NAME = "message_ref_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<MessageRefV5, DiscussionV5> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<MessageRefV5> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<MessageRefV5, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String SENDER_IDENTIFIER_NAME = "sender_identifier";
    public static final Column.ObjectColumn<MessageRefV5, byte[]> SENDER_IDENTIFIER = new Column.ObjectColumn("sender_identifier", false);
    private static final String MESSAGE_HAS_BEEN_RECEIVED_NAME = "message_has_been_received";
    public static final Column.booleanColumn<MessageRefV5> MESSAGE_HAS_BEEN_RECEIVED = new Column.booleanColumn("message_has_been_received");
    private static final String FK_OUTBOUND_MESSAGE_NAME = "fk_outbound_message";
    public static final Column.ForeignColumn<MessageRefV5, OutboundMessageV5> FK_OUTBOUND_MESSAGE = new Column.ForeignColumn("fk_outbound_message", true);
    private static final String FK_INBOUND_MESSAGE_NAME = "fk_inbound_message";
    public static final Column.ForeignColumn<MessageRefV5, InboundMessageV5> FK_INBOUND_MESSAGE = new Column.ForeignColumn("fk_inbound_message", true);
    private static final String FK_OWNED_MESSAGE_NAME = "fk_owned_message";
    public static final Column.ForeignColumn<MessageRefV5, OwnedMessageV5> FK_OWNED_MESSAGE = new Column.ForeignColumn("fk_owned_message", true);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV5 fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", uniqueCombo=true, dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="sender_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] senderIdentifier;
    @DatabaseField(columnName="message_has_been_received", dataType=DataType.BOOLEAN)
    protected boolean messageHasBeenReceived;
    @DatabaseField(columnName="fk_outbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message UNIQUE REFERENCES outbound_message_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessageV5 fkOutboundMessage;
    @DatabaseField(columnName="fk_inbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message UNIQUE REFERENCES inbound_message_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageV5 fkInboundMessage;
    @DatabaseField(columnName="fk_owned_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_message UNIQUE REFERENCES owned_message_table(gen_id) ON DELETE SET NULL")
    protected OwnedMessageV5 fkOwnedMessage;

    public MessageRefV5() {
    }

    public MessageRefV5(long genId) {
        super(genId);
    }

    public MessageRefV5(long genId, DiscussionV5 discussion, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier, boolean messageHasBeenReceived, OutboundMessageV5 outboundMessage, InboundMessageV5 inboundMessage, OwnedMessageV5 ownedMessage) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.senderIdentifier = senderIdentifier;
        this.messageHasBeenReceived = messageHasBeenReceived;
        this.fkOutboundMessage = outboundMessage;
        this.fkInboundMessage = inboundMessage;
        this.fkOwnedMessage = ownedMessage;
    }

    public Id<DiscussionV5> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public byte[] getSenderIdentifier() {
        return this.senderIdentifier;
    }

    public boolean isMessageHasBeenReceived() {
        return this.messageHasBeenReceived;
    }

    public Optional<Id<OutboundMessageV5>> getOutboundMessageId() {
        return Optional.ofNullable(this.fkOutboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<InboundMessageV5>> getInboundMessageId() {
        return Optional.ofNullable(this.fkInboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<OwnedMessageV5>> getOwnedMessageId() {
        return Optional.ofNullable(this.fkOwnedMessage).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("MessageRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRefV5 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && Arrays.equals(this.senderIdentifier, casted.senderIdentifier) && this.messageHasBeenReceived == casted.messageHasBeenReceived && Objects.equals(this.fkOutboundMessage, casted.fkOutboundMessage) && Objects.equals(this.fkInboundMessage, casted.fkInboundMessage) && Objects.equals(this.fkOwnedMessage, casted.fkOwnedMessage);
    }

    @Override
    protected Class<MessageRefV5> getClazz() {
        return MessageRefV5.class;
    }
}

