/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v4.message;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v4.ContactRefV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.DiscussionV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.OutboundMessageV4;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

@DatabaseTable(tableName="pending_message_table")
public class PendingMessageV4
extends AbstractTableGenerated<PendingMessageV4>
implements Table {
    public static final String TABLE_NAME = "pending_message_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<PendingMessageV4, DiscussionV4> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<PendingMessageV4, OutboundMessageV4> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingMessageV4, ContactRefV4> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV4 fkDiscussion;
    @DatabaseField(columnName="fk_message", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessageV4 fkMessage;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV4 fkContactRef;

    public PendingMessageV4() {
    }

    public PendingMessageV4(long genId) {
        super(genId);
    }

    public PendingMessageV4(long genId, DiscussionV4 discussion, OutboundMessageV4 message, ContactRefV4 contactRef) {
        super(genId);
        this.fkDiscussion = discussion;
        this.fkMessage = message;
        this.fkContactRef = contactRef;
    }

    public Id<DiscussionV4> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public Id<OutboundMessageV4> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Id<ContactRefV4> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public String toString() {
        return String.format("PendingMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingMessageV4 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && Objects.equals(this.fkMessage, casted.fkMessage) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<PendingMessageV4> getClazz() {
        return PendingMessageV4.class;
    }
}

