/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v4.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v4.DiscussionV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.InboundMessageV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.OutboundMessageV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.OwnedMessageV4;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="message_ref_table")
public class MessageRefV4
extends AbstractTableGenerated<MessageRefV4>
implements Table {
    public static final String TABLE_NAME = "message_ref_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<MessageRefV4, DiscussionV4> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<MessageRefV4> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<MessageRefV4, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String SENDER_IDENTIFIER_NAME = "sender_identifier";
    public static final Column.ObjectColumn<MessageRefV4, byte[]> SENDER_IDENTIFIER = new Column.ObjectColumn("sender_identifier", false);
    private static final String MESSAGE_HAS_BEEN_RECEIVED_NAME = "message_has_been_received";
    public static final Column.booleanColumn<MessageRefV4> MESSAGE_HAS_BEEN_RECEIVED = new Column.booleanColumn("message_has_been_received");
    private static final String FK_OUTBOUND_MESSAGE_NAME = "fk_outbound_message";
    public static final Column.ForeignColumn<MessageRefV4, OutboundMessageV4> FK_OUTBOUND_MESSAGE = new Column.ForeignColumn("fk_outbound_message", true);
    private static final String FK_INBOUND_MESSAGE_NAME = "fk_inbound_message";
    public static final Column.ForeignColumn<MessageRefV4, InboundMessageV4> FK_INBOUND_MESSAGE = new Column.ForeignColumn("fk_inbound_message", true);
    private static final String FK_OWNED_MESSAGE_NAME = "fk_owned_message";
    public static final Column.ForeignColumn<MessageRefV4, OwnedMessageV4> FK_OWNED_MESSAGE = new Column.ForeignColumn("fk_owned_message", true);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV4 fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", uniqueCombo=true, dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="sender_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] senderIdentifier;
    @DatabaseField(columnName="message_has_been_received", dataType=DataType.BOOLEAN)
    protected boolean messageHasBeenReceived;
    @DatabaseField(columnName="fk_outbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message UNIQUE REFERENCES outbound_message_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessageV4 fkOutboundMessage;
    @DatabaseField(columnName="fk_inbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message UNIQUE REFERENCES inbound_message_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageV4 fkInboundMessage;
    @DatabaseField(columnName="fk_owned_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_message UNIQUE REFERENCES owned_message_table(gen_id) ON DELETE SET NULL")
    protected OwnedMessageV4 fkOwnedMessage;

    public MessageRefV4() {
    }

    public MessageRefV4(long genId) {
        super(genId);
    }

    public MessageRefV4(long genId, DiscussionV4 discussion, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier, boolean messageHasBeenReceived, OutboundMessageV4 outboundMessage, InboundMessageV4 inboundMessage, OwnedMessageV4 ownedMessage) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.senderIdentifier = senderIdentifier;
        this.messageHasBeenReceived = messageHasBeenReceived;
        this.fkOutboundMessage = outboundMessage;
        this.fkInboundMessage = inboundMessage;
        this.fkOwnedMessage = ownedMessage;
    }

    public Id<DiscussionV4> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public byte[] getSenderIdentifier() {
        return this.senderIdentifier;
    }

    public boolean isMessageHasBeenReceived() {
        return this.messageHasBeenReceived;
    }

    public Optional<Id<OutboundMessageV4>> getOutboundMessageId() {
        return Optional.ofNullable(this.fkOutboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<InboundMessageV4>> getInboundMessageId() {
        return Optional.ofNullable(this.fkInboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<OwnedMessageV4>> getOwnedMessageId() {
        return Optional.ofNullable(this.fkOwnedMessage).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("MessageRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRefV4 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && Arrays.equals(this.senderIdentifier, casted.senderIdentifier) && this.messageHasBeenReceived == casted.messageHasBeenReceived && Objects.equals(this.fkOutboundMessage, casted.fkOutboundMessage) && Objects.equals(this.fkInboundMessage, casted.fkInboundMessage) && Objects.equals(this.fkOwnedMessage, casted.fkOwnedMessage);
    }

    @Override
    protected Class<MessageRefV4> getClazz() {
        return MessageRefV4.class;
    }
}

