/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v3;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v3.CapabilitiesV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.IdentityDetailsV3;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="owned_identity_table")
public class OwnedIdentityV3
extends AbstractTableGenerated<OwnedIdentityV3>
implements Table {
    public static final String TABLE_NAME = "owned_identity_table";
    private static final String BYTES_OWNED_IDENTITY_NAME = "bytes_owned_identity";
    public static final Column.ObjectColumn<OwnedIdentityV3, byte[]> BYTES_OWNED_IDENTITY = new Column.ObjectColumn("bytes_owned_identity", false);
    private static final String NICKNAME_NAME = "nickname";
    public static final Column.ObjectColumn<OwnedIdentityV3, String> NICKNAME = new Column.ObjectColumn("nickname", true);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<OwnedIdentityV3, IdentityDetailsV3> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    private static final String API_KEY_STATUS_NAME = "api_key_status";
    public static final Column.ObjectColumn<OwnedIdentityV3, ApiKeyStatus> API_KEY_STATUS = new Column.ObjectColumn("api_key_status", false);
    private static final String UNPUBLISHED_DETAILS_NAME = "unpublished_details";
    public static final Column.ObjectColumn<OwnedIdentityV3, UnpublishedDetails> UNPUBLISHED_DETAILS = new Column.ObjectColumn("unpublished_details", false);
    private static final String API_KEY_PERMISSIONS_NAME = "api_key_permissions";
    public static final Column.longColumn<OwnedIdentityV3> API_KEY_PERMISSIONS = new Column.longColumn("api_key_permissions");
    private static final String API_KEY_EXPIRATION_TIMESTAMP_NAME = "api_key_expiration_timestamp";
    public static final Column.ObjectColumn<OwnedIdentityV3, Long> API_KEY_EXPIRATION_TIMESTAMP = new Column.ObjectColumn("api_key_expiration_timestamp", true);
    private static final String KEYCLOAK_MANAGED_NAME = "keycloak_managed";
    public static final Column.booleanColumn<OwnedIdentityV3> KEYCLOAK_MANAGED = new Column.booleanColumn("keycloak_managed");
    private static final String ACTIVE_NAME = "active";
    public static final Column.booleanColumn<OwnedIdentityV3> ACTIVE = new Column.booleanColumn("active");
    private static final String FK_CAPABILITIES_NAME = "fk_capabilities";
    public static final Column.ForeignColumn<OwnedIdentityV3, CapabilitiesV3> FK_CAPABILITIES = new Column.ForeignColumn("fk_capabilities", false);
    @DatabaseField(columnName="bytes_owned_identity", unique=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesOwnedIdentity;
    @DatabaseField(columnName="nickname", dataType=DataType.STRING)
    protected String nickname;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details UNIQUE NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetailsV3 fkIdentityDetails;
    @DatabaseField(columnName="api_key_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected ApiKeyStatus apiKeyStatus;
    @DatabaseField(columnName="unpublished_details", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected UnpublishedDetails unpublishedDetails;
    @DatabaseField(columnName="api_key_permissions", dataType=DataType.LONG)
    protected long apiKeyPermissions;
    @DatabaseField(columnName="api_key_expiration_timestamp", dataType=DataType.LONG_OBJ)
    protected Long apiKeyExpirationTimestamp;
    @DatabaseField(columnName="keycloak_managed", dataType=DataType.BOOLEAN)
    protected boolean keycloakManaged;
    @DatabaseField(columnName="active", dataType=DataType.BOOLEAN)
    protected boolean active;
    @DatabaseField(columnName="fk_capabilities", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_capabilities UNIQUE NOT NULL REFERENCES capabilities_table(gen_id)")
    protected CapabilitiesV3 fkCapabilities;

    public OwnedIdentityV3() {
    }

    public OwnedIdentityV3(long genId) {
        super(genId);
    }

    public OwnedIdentityV3(long genId, byte[] bytesOwnedIdentity, String nickname, IdentityDetailsV3 identityDetails, ApiKeyStatus apiKeyStatus, UnpublishedDetails unpublishedDetails, long apiKeyPermissions, Long apiKeyExpirationTimestamp, boolean keycloakManaged, boolean active, CapabilitiesV3 capabilities) {
        super(genId);
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.nickname = nickname;
        this.fkIdentityDetails = identityDetails;
        this.apiKeyStatus = apiKeyStatus;
        this.unpublishedDetails = unpublishedDetails;
        this.apiKeyPermissions = apiKeyPermissions;
        this.apiKeyExpirationTimestamp = apiKeyExpirationTimestamp;
        this.keycloakManaged = keycloakManaged;
        this.active = active;
        this.fkCapabilities = capabilities;
    }

    public byte[] getBytesOwnedIdentity() {
        return this.bytesOwnedIdentity;
    }

    public Optional<String> getNickname() {
        return Optional.ofNullable(this.nickname);
    }

    public Id<IdentityDetailsV3> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public ApiKeyStatus getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public void setApiKeyStatus(ApiKeyStatus apiKeyStatus) {
        this.apiKeyStatus = apiKeyStatus;
    }

    public UnpublishedDetails getUnpublishedDetails() {
        return this.unpublishedDetails;
    }

    public void setUnpublishedDetails(UnpublishedDetails unpublishedDetails) {
        this.unpublishedDetails = unpublishedDetails;
    }

    public long getApiKeyPermissions() {
        return this.apiKeyPermissions;
    }

    public Optional<Long> getApiKeyExpirationTimestamp() {
        return Optional.ofNullable(this.apiKeyExpirationTimestamp);
    }

    public void setApiKeyExpirationTimestamp(Optional<Long> apiKeyExpirationTimestamp) {
        this.apiKeyExpirationTimestamp = apiKeyExpirationTimestamp.orElse(null);
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged;
    }

    public boolean isActive() {
        return this.active;
    }

    public Id<CapabilitiesV3> getCapabilitiesId() {
        return this.fkCapabilities.getItemId();
    }

    public String toString() {
        return String.format("OwnedIdentity[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OwnedIdentityV3 casted = this.getClazz().cast(obj);
        return Arrays.equals(this.bytesOwnedIdentity, casted.bytesOwnedIdentity) && Objects.equals(this.nickname, casted.nickname) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails) && this.apiKeyStatus == casted.apiKeyStatus && this.unpublishedDetails == casted.unpublishedDetails && this.apiKeyPermissions == casted.apiKeyPermissions && Objects.equals(this.apiKeyExpirationTimestamp, casted.apiKeyExpirationTimestamp) && this.keycloakManaged == casted.keycloakManaged && this.active == casted.active && Objects.equals(this.fkCapabilities, casted.fkCapabilities);
    }

    @Override
    protected Class<OwnedIdentityV3> getClazz() {
        return OwnedIdentityV3.class;
    }

    public static enum ApiKeyStatus implements IComparable<ApiKeyStatus>
    {
        UNKNOWN,
        VALID,
        LICENSES_EXHAUSTED,
        EXPIRED,
        OPEN_BETA_KEY,
        FREE_TRIAL_KEY,
        AWAITING_PAYMENT_GRACE_PERIOD,
        AWAITING_PAYMENT_ON_HOLD,
        FREE_TRIAL_KEY_EXPIRED;

    }

    public static enum UnpublishedDetails implements IComparable<UnpublishedDetails>
    {
        NOTHING_NEW,
        EXIST;

    }
}

