/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v3;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v3.ContactGroupJoinV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.GroupV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.OwnedIdentityV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.PendingGroupMemberV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.PreGroupV3;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="group_member_permissions_table")
public class GroupMemberPermissionsV3
extends AbstractTableGenerated<GroupMemberPermissionsV3>
implements Table {
    public static final String TABLE_NAME = "group_member_permissions_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<GroupMemberPermissionsV3, OwnedIdentityV3> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<GroupMemberPermissionsV3, GroupV3> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<GroupMemberPermissionsV3, PreGroupV3> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String FK_CONTACT_GROUP_JOIN_NAME = "fk_contact_group_join";
    public static final Column.ForeignColumn<GroupMemberPermissionsV3, ContactGroupJoinV3> FK_CONTACT_GROUP_JOIN = new Column.ForeignColumn("fk_contact_group_join", true);
    private static final String FK_PENDING_GROUP_MEMBER_NAME = "fk_pending_group_member";
    public static final Column.ForeignColumn<GroupMemberPermissionsV3, PendingGroupMemberV3> FK_PENDING_GROUP_MEMBER = new Column.ForeignColumn("fk_pending_group_member", true);
    private static final String ADMIN_NAME = "admin";
    public static final Column.booleanColumn<GroupMemberPermissionsV3> ADMIN = new Column.booleanColumn("admin");
    private static final String REMOTE_DELETE_ANYTHING_NAME = "remote_delete_anything";
    public static final Column.booleanColumn<GroupMemberPermissionsV3> REMOTE_DELETE_ANYTHING = new Column.booleanColumn("remote_delete_anything");
    private static final String EDIT_OR_REMOTE_DELETE_OWN_MESSAGES_NAME = "edit_or_remote_delete_own_messages";
    public static final Column.booleanColumn<GroupMemberPermissionsV3> EDIT_OR_REMOTE_DELETE_OWN_MESSAGES = new Column.booleanColumn("edit_or_remote_delete_own_messages");
    private static final String CHANGE_SETTINGS_NAME = "change_settings";
    public static final Column.booleanColumn<GroupMemberPermissionsV3> CHANGE_SETTINGS = new Column.booleanColumn("change_settings");
    private static final String SEND_MESSAGE_NAME = "send_message";
    public static final Column.booleanColumn<GroupMemberPermissionsV3> SEND_MESSAGE = new Column.booleanColumn("send_message");
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV3 fkOwnedIdentity;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected GroupV3 fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group REFERENCES pre_group_table(gen_id) ON DELETE CASCADE")
    protected PreGroupV3 fkPreGroup;
    @DatabaseField(columnName="fk_contact_group_join", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_group_join REFERENCES contact_group_join_table(gen_id) ON DELETE CASCADE")
    protected ContactGroupJoinV3 fkContactGroupJoin;
    @DatabaseField(columnName="fk_pending_group_member", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pending_group_member REFERENCES pending_group_member_table(gen_id) ON DELETE CASCADE")
    protected PendingGroupMemberV3 fkPendingGroupMember;
    @DatabaseField(columnName="admin", dataType=DataType.BOOLEAN)
    protected boolean admin;
    @DatabaseField(columnName="remote_delete_anything", dataType=DataType.BOOLEAN)
    protected boolean remoteDeleteAnything;
    @DatabaseField(columnName="edit_or_remote_delete_own_messages", dataType=DataType.BOOLEAN)
    protected boolean editOrRemoteDeleteOwnMessages;
    @DatabaseField(columnName="change_settings", dataType=DataType.BOOLEAN)
    protected boolean changeSettings;
    @DatabaseField(columnName="send_message", dataType=DataType.BOOLEAN)
    protected boolean sendMessage;
    @DatabaseField(columnName="virtual_fk_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_group, 0)) VIRTUAL")
    private long virtualGroup;
    @DatabaseField(columnName="virtual_fk_pre_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pre_group, 0)) VIRTUAL")
    private long virtualPreGroup;
    @DatabaseField(columnName="virtual_fk_contact_group_join", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_contact_group_join, 0)) VIRTUAL")
    private long virtualContactGroupJoin;
    @DatabaseField(columnName="virtual_fk_pending_group_member", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pending_group_member, 0)) VIRTUAL")
    private long virtualPendingGroupMember;

    public GroupMemberPermissionsV3() {
    }

    public GroupMemberPermissionsV3(long genId) {
        super(genId);
    }

    public GroupMemberPermissionsV3(long genId, OwnedIdentityV3 ownedIdentity, GroupV3 group, PreGroupV3 preGroup, ContactGroupJoinV3 contactGroupJoin, PendingGroupMemberV3 pendingGroupMember, boolean admin, boolean remoteDeleteAnything, boolean editOrRemoteDeleteOwnMessages, boolean changeSettings, boolean sendMessage) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.fkContactGroupJoin = contactGroupJoin;
        this.fkPendingGroupMember = pendingGroupMember;
        this.admin = admin;
        this.remoteDeleteAnything = remoteDeleteAnything;
        this.editOrRemoteDeleteOwnMessages = editOrRemoteDeleteOwnMessages;
        this.changeSettings = changeSettings;
        this.sendMessage = sendMessage;
    }

    public Id<OwnedIdentityV3> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Optional<Id<GroupV3>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PreGroupV3>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactGroupJoinV3>> getContactGroupJoinId() {
        return Optional.ofNullable(this.fkContactGroupJoin).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PendingGroupMemberV3>> getPendingGroupMemberId() {
        return Optional.ofNullable(this.fkPendingGroupMember).map(AbstractTableGenerated::getItemId);
    }

    public boolean hasPermissionAdmin() {
        return this.admin;
    }

    public boolean hasPermissionRemoteDeleteAnything() {
        return this.remoteDeleteAnything;
    }

    public boolean hasPermissionEditOrRemoteDeleteOwnMessages() {
        return this.editOrRemoteDeleteOwnMessages;
    }

    public boolean hasPermissionChangeSettings() {
        return this.changeSettings;
    }

    public boolean hasPermissionSendMessage() {
        return this.sendMessage;
    }

    public String toString() {
        return String.format("GroupMemberPermissions[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        GroupMemberPermissionsV3 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && Objects.equals(this.fkContactGroupJoin, casted.fkContactGroupJoin) && Objects.equals(this.fkPendingGroupMember, casted.fkPendingGroupMember) && this.admin == casted.admin && this.remoteDeleteAnything == casted.remoteDeleteAnything && this.editOrRemoteDeleteOwnMessages == casted.editOrRemoteDeleteOwnMessages && this.changeSettings == casted.changeSettings && this.sendMessage == casted.sendMessage;
    }

    @Override
    protected Class<GroupMemberPermissionsV3> getClazz() {
        return GroupMemberPermissionsV3.class;
    }
}

