/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v2;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v2.ContactV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.GroupV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.OwnedIdentityV2;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

@DatabaseTable(tableName="contact_group_join_table")
public class ContactGroupJoinV2
extends AbstractTableGenerated<ContactGroupJoinV2>
implements Table {
    public static final String TABLE_NAME = "contact_group_join_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<ContactGroupJoinV2, OwnedIdentityV2> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<ContactGroupJoinV2, ContactV2> FK_CONTACT = new Column.ForeignColumn("fk_contact", false);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<ContactGroupJoinV2, GroupV2> FK_GROUP = new Column.ForeignColumn("fk_group", false);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<ContactGroupJoinV2> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV2 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact NOT NULL REFERENCES contact_table(gen_id) ON DELETE CASCADE")
    protected ContactV2 fkContact;
    @DatabaseField(columnName="fk_group", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group NOT NULL REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected GroupV2 fkGroup;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public ContactGroupJoinV2() {
    }

    public ContactGroupJoinV2(long genId) {
        super(genId);
    }

    public ContactGroupJoinV2(long genId, OwnedIdentityV2 ownedIdentity, ContactV2 contact, GroupV2 group, long timestamp) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContact = contact;
        this.fkGroup = group;
        this.timestamp = timestamp;
    }

    public Id<OwnedIdentityV2> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Id<ContactV2> getContactId() {
        return this.fkContact.getItemId();
    }

    public Id<GroupV2> getGroupId() {
        return this.fkGroup.getItemId();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("ContactGroupJoin[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ContactGroupJoinV2 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContact, casted.fkContact) && Objects.equals(this.fkGroup, casted.fkGroup) && this.timestamp == casted.timestamp;
    }

    @Override
    protected Class<ContactGroupJoinV2> getClazz() {
        return ContactGroupJoinV2.class;
    }
}

