/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.GroupV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.IdentityRefV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageChoiceV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="poll_message_vote_table")
public class PollMessageVoteV10
extends AbstractTableGenerated<PollMessageVoteV10>
implements Table {
    public static final String TABLE_NAME = "poll_message_vote_table";
    private static final String FK_POLL_MESSAGE_NAME = "fk_poll_message";
    public static final Column.ForeignColumn<PollMessageVoteV10, PollMessageV10> FK_POLL_MESSAGE = new Column.ForeignColumn("fk_poll_message", true);
    private static final String FK_POLL_MESSAGE_CHOICE_NAME = "fk_poll_message_choice";
    public static final Column.ForeignColumn<PollMessageVoteV10, PollMessageChoiceV10> FK_POLL_MESSAGE_CHOICE = new Column.ForeignColumn("fk_poll_message_choice", true);
    private static final String FK_IDENTITY_REF_NAME = "fk_identity_ref";
    public static final Column.ForeignColumn<PollMessageVoteV10, IdentityRefV10> FK_IDENTITY_REF = new Column.ForeignColumn("fk_identity_ref", true);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<PollMessageVoteV10, GroupV10> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.ObjectColumn<PollMessageVoteV10, Long> TIMESTAMP = new Column.ObjectColumn("timestamp", false);
    private static final String VOTED_NAME = "voted";
    public static final Column.booleanColumn<PollMessageVoteV10> VOTED = new Column.booleanColumn("voted");
    private static final String VERSION_NAME = "version";
    public static final Column.intColumn<PollMessageVoteV10> VERSION = new Column.intColumn("version");
    @DatabaseField(columnName="fk_poll_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message REFERENCES poll_message_table(gen_id) ON DELETE CASCADE")
    protected PollMessageV10 fkPollMessage;
    @DatabaseField(columnName="fk_poll_message_choice", foreign=true, foreignAutoRefresh=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message_choice REFERENCES poll_message_choice_table(gen_id) ON DELETE CASCADE")
    protected PollMessageChoiceV10 fkPollMessageChoice;
    @DatabaseField(columnName="fk_identity_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_ref REFERENCES identity_ref_table(gen_id)")
    protected IdentityRefV10 fkIdentityRef;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE SET NULL")
    protected GroupV10 fkGroup;
    @DatabaseField(columnName="timestamp", canBeNull=false, dataType=DataType.LONG_OBJ)
    protected Long timestamp;
    @DatabaseField(columnName="voted", dataType=DataType.BOOLEAN)
    protected boolean voted;
    @DatabaseField(columnName="version", dataType=DataType.INTEGER)
    protected int version;
    @DatabaseField(columnName="virtual_fk_poll_message", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_poll_message, 0)) VIRTUAL")
    private long virtualPollMessage;
    @DatabaseField(columnName="virtual_fk_poll_message_choice", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_poll_message_choice, 0)) VIRTUAL")
    private long virtualPollMessageChoice;
    @DatabaseField(columnName="virtual_fk_identity_ref", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_identity_ref, 0)) VIRTUAL")
    private long virtualIdentityRef;

    public PollMessageVoteV10() {
    }

    public PollMessageVoteV10(long genId) {
        super(genId);
    }

    public PollMessageVoteV10(long genId, PollMessageV10 pollMessage, PollMessageChoiceV10 pollMessageChoice, IdentityRefV10 identityRef, GroupV10 group, Long timestamp, boolean voted, int version) {
        super(genId);
        this.fkPollMessage = pollMessage;
        this.fkPollMessageChoice = pollMessageChoice;
        this.fkIdentityRef = identityRef;
        this.fkGroup = group;
        this.timestamp = timestamp;
        this.voted = voted;
        this.version = version;
    }

    public Optional<Id<PollMessageV10>> getPollMessageId() {
        return Optional.ofNullable(this.fkPollMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<PollMessageChoiceV10> getPollMessageChoice() {
        return Optional.ofNullable(this.fkPollMessageChoice);
    }

    public void setPollMessageChoice(Optional<PollMessageChoiceV10> fkPollMessageChoice) {
        this.fkPollMessageChoice = fkPollMessageChoice.orElse(null);
    }

    public Optional<Id<IdentityRefV10>> getIdentityRefId() {
        return Optional.ofNullable(this.fkIdentityRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<GroupV10>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isVoted() {
        return this.voted;
    }

    public void setVoted(boolean voted) {
        this.voted = voted;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return String.format("PollMessageVote[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PollMessageVoteV10 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkPollMessage, casted.fkPollMessage) && Objects.equals(this.fkPollMessageChoice, casted.fkPollMessageChoice) && Objects.equals(this.fkIdentityRef, casted.fkIdentityRef) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.timestamp, casted.timestamp) && this.voted == casted.voted && this.version == casted.version;
    }

    @Override
    protected Class<PollMessageVoteV10> getClazz() {
        return PollMessageVoteV10.class;
    }
}

