/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="poll_message_option_table")
public class PollMessageOptionV10
extends AbstractTableGenerated<PollMessageOptionV10>
implements Table {
    public static final String TABLE_NAME = "poll_message_option_table";
    private static final String FK_POLL_MESSAGE_NAME = "fk_poll_message";
    public static final Column.ForeignColumn<PollMessageOptionV10, PollMessageV10> FK_POLL_MESSAGE = new Column.ForeignColumn("fk_poll_message", true);
    private static final String OPTION_TEXT_NAME = "option_text";
    public static final Column.ObjectColumn<PollMessageOptionV10, String> OPTION_TEXT = new Column.ObjectColumn("option_text", false);
    @DatabaseField(columnName="fk_poll_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message REFERENCES poll_message_table(gen_id) ON DELETE CASCADE")
    protected PollMessageV10 fkPollMessage;
    @DatabaseField(columnName="option_text", canBeNull=false, dataType=DataType.STRING)
    protected String optionText;

    public PollMessageOptionV10() {
    }

    public PollMessageOptionV10(long genId) {
        super(genId);
    }

    public PollMessageOptionV10(long genId, PollMessageV10 pollMessage, String optionText) {
        super(genId);
        this.fkPollMessage = pollMessage;
        this.optionText = optionText;
    }

    public Optional<Id<PollMessageV10>> getPollMessageId() {
        return Optional.ofNullable(this.fkPollMessage).map(AbstractTableGenerated::getItemId);
    }

    public String getOptionText() {
        return this.optionText;
    }

    public String toString() {
        return String.format("PollMessageOption[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PollMessageOptionV10 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkPollMessage, casted.fkPollMessage) && Objects.equals(this.optionText, casted.optionText);
    }

    @Override
    protected Class<PollMessageOptionV10> getClazz() {
        return PollMessageOptionV10.class;
    }
}

