/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="poll_message_choice_table")
public class PollMessageChoiceV10
extends AbstractTableGenerated<PollMessageChoiceV10>
implements Table {
    public static final String TABLE_NAME = "poll_message_choice_table";
    private static final String FK_POLL_MESSAGE_NAME = "fk_poll_message";
    public static final Column.ForeignColumn<PollMessageChoiceV10, PollMessageV10> FK_POLL_MESSAGE = new Column.ForeignColumn("fk_poll_message", true);
    private static final String EXTERNAL_IDENTIFIER_NAME = "external_identifier";
    public static final Column.ObjectColumn<PollMessageChoiceV10, UUID> EXTERNAL_IDENTIFIER = new Column.ObjectColumn("external_identifier", false);
    private static final String LABEL_NAME = "label";
    public static final Column.ObjectColumn<PollMessageChoiceV10, String> LABEL = new Column.ObjectColumn("label", false);
    @DatabaseField(columnName="fk_poll_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_poll_message REFERENCES poll_message_table(gen_id) ON DELETE CASCADE")
    protected PollMessageV10 fkPollMessage;
    @DatabaseField(columnName="external_identifier", canBeNull=false, dataType=DataType.UUID)
    protected UUID externalIdentifier;
    @DatabaseField(columnName="label", canBeNull=false, dataType=DataType.STRING)
    protected String label;

    public PollMessageChoiceV10() {
    }

    public PollMessageChoiceV10(long genId) {
        super(genId);
    }

    public PollMessageChoiceV10(long genId, PollMessageV10 pollMessage, UUID externalIdentifier, String label) {
        super(genId);
        this.fkPollMessage = pollMessage;
        this.externalIdentifier = externalIdentifier;
        this.label = label;
    }

    public Optional<Id<PollMessageV10>> getPollMessageId() {
        return Optional.ofNullable(this.fkPollMessage).map(AbstractTableGenerated::getItemId);
    }

    public UUID getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return String.format("PollMessageChoice[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PollMessageChoiceV10 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkPollMessage, casted.fkPollMessage) && Objects.equals(this.externalIdentifier, casted.externalIdentifier) && Objects.equals(this.label, casted.label);
    }

    @Override
    protected Class<PollMessageChoiceV10> getClazz() {
        return PollMessageChoiceV10.class;
    }
}

