/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.DiscussionV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.LocationV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.ephemerality.OutboundMessageEphemeralInfoV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.message.AbstractUserMessageV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.message.MessageRefV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="outbound_message_table")
public class OutboundMessageV10
extends AbstractUserMessageV10<OutboundMessageV10>
implements Table {
    public static final String TABLE_NAME = "outbound_message_table";
    private static final String CREATE_VIRTUAL_STATEMENT = "CREATE VIRTUAL TABLE IF NOT EXISTS outbound_message_table_fts USING fts5(`body`, tokenize=\"unicode61 remove_diacritics 2\", content='outbound_message_table', content_rowid='gen_id');";
    private static final String AFTER_CREATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_ai AFTER INSERT ON outbound_message_table BEGIN  INSERT INTO outbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END;";
    private static final String AFTER_UPDATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_au AFTER UPDATE ON outbound_message_table FOR EACH ROW  WHEN  ( new.body IS NOT old.body ) BEGIN  INSERT INTO outbound_message_table_fts (`outbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); INSERT INTO outbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END; ";
    private static final String AFTER_DELETE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_ad AFTER DELETE ON outbound_message_table BEGIN  INSERT INTO outbound_message_table_fts (`outbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); END;";
    private static final String FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_outbound_message_ephemeral_info";
    public static final Column.ForeignColumn<OutboundMessageV10, OutboundMessageEphemeralInfoV10> FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_outbound_message_ephemeral_info", true);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<OutboundMessageV10, Status> STATUS = new Column.ObjectColumn("status", false);
    @ExtraStatements
    public static final List<String> ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS;
    @DatabaseField(columnName="fk_outbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message_ephemeral_info REFERENCES outbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessageEphemeralInfoV10 fkOutboundMessageEphemeralInfo;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;

    public OutboundMessageV10() {
    }

    public OutboundMessageV10(long genId) {
        super(genId);
    }

    public OutboundMessageV10(long genId, DiscussionV10 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV10 replyTo, LocationV10 location, AbstractUserMessageV10.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageV10.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageV10.EditionStatus editionStatus, boolean forwarded, PollMessageV10 pollMessage, OutboundMessageEphemeralInfoV10 outboundMessageEphemeralInfo, Status status) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage);
        this.fkOutboundMessageEphemeralInfo = outboundMessageEphemeralInfo;
        this.status = status;
    }

    public Optional<Id<OutboundMessageEphemeralInfoV10>> getOutboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkOutboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return String.format("OutboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OutboundMessageV10 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkOutboundMessageEphemeralInfo, casted.fkOutboundMessageEphemeralInfo) && this.status == casted.status;
    }

    @Override
    protected Class<OutboundMessageV10> getClazz() {
        return OutboundMessageV10.class;
    }

    static {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(CREATE_VIRTUAL_STATEMENT);
        statements.add(AFTER_CREATE_STATEMENT);
        statements.add(AFTER_UPDATE_STATEMENT);
        statements.add(AFTER_DELETE_STATEMENT);
        ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS = List.copyOf(statements);
    }

    public static enum Status implements IComparable<Status>
    {
        FAILED,
        UNDELIVERED,
        NO_CONTACT_RECIPIENTS,
        DRAFT,
        UNPROCESSED,
        PROCESSING,
        SENT,
        DELIVERED,
        DELIVERED_AND_READ,
        PARTIALLY_DELIVERED_NOT_READ,
        PARTIALLY_DELIVERED_PARTIALLY_READ,
        FULLY_DELIVERED_NOT_READ,
        FULLY_DELIVERED_PARTIALLY_READ,
        FULLY_DELIVERED_FULLY_READ;

    }
}

