/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.ContactRefV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.DiscussionV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.LocationV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.ephemerality.InboundMessageEphemeralInfoV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.message.AbstractUserMessageV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.message.MessageRefV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.message.ReceivedMessageV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.pollMessage.PollMessageV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="inbound_message_table")
public class InboundMessageV10
extends ReceivedMessageV10<InboundMessageV10>
implements Table {
    public static final String TABLE_NAME = "inbound_message_table";
    private static final String CREATE_VIRTUAL_STATEMENT = "CREATE VIRTUAL TABLE IF NOT EXISTS inbound_message_table_fts USING fts5(`body`, tokenize=\"unicode61 remove_diacritics 2\", content='inbound_message_table', content_rowid='gen_id');";
    private static final String AFTER_CREATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_ai AFTER INSERT ON inbound_message_table BEGIN  INSERT INTO inbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END;";
    private static final String AFTER_UPDATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_au AFTER UPDATE ON inbound_message_table FOR EACH ROW  WHEN  ( new.body IS NOT old.body ) BEGIN  INSERT INTO inbound_message_table_fts (`inbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); INSERT INTO inbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END; ";
    private static final String AFTER_DELETE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS inbound_message_table_ad AFTER DELETE ON inbound_message_table BEGIN  INSERT INTO inbound_message_table_fts (`inbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); END;";
    private static final String FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_inbound_message_ephemeral_info";
    public static final Column.ForeignColumn<InboundMessageV10, InboundMessageEphemeralInfoV10> FK_INBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_inbound_message_ephemeral_info", true);
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<InboundMessageV10, ContactRefV10> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<InboundMessageV10, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String BOXED_NAME = "boxed";
    public static final Column.booleanColumn<InboundMessageV10> BOXED = new Column.booleanColumn("boxed");
    @ExtraStatements
    public static final List<String> ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS;
    @DatabaseField(columnName="fk_inbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message_ephemeral_info REFERENCES inbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageEphemeralInfoV10 fkInboundMessageEphemeralInfo;
    @DatabaseField(columnName="fk_sender", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES contact_ref_table(gen_id)")
    protected ContactRefV10 fkSender;
    @DatabaseField(columnName="status", index=true, canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="boxed", dataType=DataType.BOOLEAN)
    protected boolean boxed;

    public InboundMessageV10() {
    }

    public InboundMessageV10(long genId) {
        super(genId);
    }

    public InboundMessageV10(long genId, DiscussionV10 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV10 replyTo, LocationV10 location, AbstractUserMessageV10.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageV10.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageV10.EditionStatus editionStatus, boolean forwarded, PollMessageV10 pollMessage, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount, InboundMessageEphemeralInfoV10 inboundMessageEphemeralInfo, ContactRefV10 sender, Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, pollMessage, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier, missedMessageCount);
        this.fkInboundMessageEphemeralInfo = inboundMessageEphemeralInfo;
        this.fkSender = sender;
        this.status = status;
        this.boxed = boxed;
    }

    public Optional<Id<InboundMessageEphemeralInfoV10>> getInboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkInboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRefV10> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
    }

    @Override
    public String toString() {
        return String.format("InboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InboundMessageV10 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkInboundMessageEphemeralInfo, casted.fkInboundMessageEphemeralInfo) && Objects.equals(this.fkSender, casted.fkSender) && this.status == casted.status && this.boxed == casted.boxed;
    }

    @Override
    protected Class<InboundMessageV10> getClazz() {
        return InboundMessageV10.class;
    }

    static {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(CREATE_VIRTUAL_STATEMENT);
        statements.add(AFTER_CREATE_STATEMENT);
        statements.add(AFTER_UPDATE_STATEMENT);
        statements.add(AFTER_DELETE_STATEMENT);
        ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS = List.copyOf(statements);
    }

    public static enum Status implements IComparable<Status>
    {
        UNREAD,
        READ;

    }
}

