/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.OwnedIdentityV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="group_table")
public class GroupV10
extends AbstractTableGenerated<GroupV10>
implements Table {
    public static final String TABLE_NAME = "group_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<GroupV10, OwnedIdentityV10> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String BYTES_GROUP_IDENTIFIER_NAME = "bytes_group_identifier";
    public static final Column.ObjectColumn<GroupV10, byte[]> BYTES_GROUP_IDENTIFIER = new Column.ObjectColumn("bytes_group_identifier", false);
    private static final String VERSION_NAME = "version";
    public static final Column.ObjectColumn<GroupV10, Version> VERSION = new Column.ObjectColumn("version", false);
    private static final String KEYCLOAK_MANAGED_NAME = "keycloak_managed";
    public static final Column.booleanColumn<GroupV10> KEYCLOAK_MANAGED = new Column.booleanColumn("keycloak_managed");
    private static final String NEW_PUBLISHED_DETAILS_NAME = "new_published_details";
    public static final Column.ObjectColumn<GroupV10, PublishedDetails> NEW_PUBLISHED_DETAILS = new Column.ObjectColumn("new_published_details", false);
    private static final String NAME_NAME = "name";
    public static final Column.ObjectColumn<GroupV10, String> NAME = new Column.ObjectColumn("name", true);
    private static final String DESCRIPTION_NAME = "description";
    public static final Column.ObjectColumn<GroupV10, String> DESCRIPTION = new Column.ObjectColumn("description", true);
    private static final String PHOTO_URL_NAME = "photo_url";
    public static final Column.ObjectColumn<GroupV10, String> PHOTO_URL = new Column.ObjectColumn("photo_url", true);
    private static final String CUSTOM_NAME_NAME = "custom_name";
    public static final Column.ObjectColumn<GroupV10, String> CUSTOM_NAME = new Column.ObjectColumn("custom_name", true);
    private static final String GROUP_MEMBERS_NAMES_NAME = "group_members_names";
    public static final Column.ObjectColumn<GroupV10, String> GROUP_MEMBERS_NAMES = new Column.ObjectColumn("group_members_names", true);
    private static final String CUSTOM_PHOTO_URL_NAME = "custom_photo_url";
    public static final Column.ObjectColumn<GroupV10, String> CUSTOM_PHOTO_URL = new Column.ObjectColumn("custom_photo_url", true);
    private static final String UPDATE_IN_PROGRESS_NAME = "update_in_progress";
    public static final Column.ObjectColumn<GroupV10, Update> UPDATE_IN_PROGRESS = new Column.ObjectColumn("update_in_progress", false);
    private static final String PERSONAL_NOTE_NAME = "personal_note";
    public static final Column.ObjectColumn<GroupV10, String> PERSONAL_NOTE = new Column.ObjectColumn("personal_note", true);
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV10 fkOwnedIdentity;
    @DatabaseField(columnName="bytes_group_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesGroupIdentifier;
    @DatabaseField(columnName="version", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Version version;
    @DatabaseField(columnName="keycloak_managed", dataType=DataType.BOOLEAN)
    protected boolean keycloakManaged;
    @DatabaseField(columnName="new_published_details", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected PublishedDetails newPublishedDetails;
    @DatabaseField(columnName="name", dataType=DataType.STRING)
    protected String name;
    @DatabaseField(columnName="description", dataType=DataType.STRING)
    protected String description;
    @DatabaseField(columnName="photo_url", dataType=DataType.STRING)
    protected String photoUrl;
    @DatabaseField(columnName="custom_name", dataType=DataType.STRING)
    protected String customName;
    @DatabaseField(columnName="group_members_names", dataType=DataType.STRING)
    protected String groupMembersNames;
    @DatabaseField(columnName="custom_photo_url", dataType=DataType.STRING)
    protected String customPhotoUrl;
    @DatabaseField(columnName="update_in_progress", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Update updateInProgress;
    @DatabaseField(columnName="personal_note", dataType=DataType.STRING)
    protected String personalNote;

    public GroupV10() {
    }

    public GroupV10(long genId) {
        super(genId);
    }

    public GroupV10(long genId, OwnedIdentityV10 ownedIdentity, byte[] bytesGroupIdentifier, Version version, boolean keycloakManaged, PublishedDetails newPublishedDetails, String name, String description, String photoUrl, String customName, String groupMembersNames, String customPhotoUrl, Update updateInProgress, String personalNote) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.bytesGroupIdentifier = bytesGroupIdentifier;
        this.version = version;
        this.keycloakManaged = keycloakManaged;
        this.newPublishedDetails = newPublishedDetails;
        this.name = name;
        this.description = description;
        this.photoUrl = photoUrl;
        this.customName = customName;
        this.groupMembersNames = groupMembersNames;
        this.customPhotoUrl = customPhotoUrl;
        this.updateInProgress = updateInProgress;
        this.personalNote = personalNote;
    }

    public Id<OwnedIdentityV10> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public byte[] getBytesGroupIdentifier() {
        return this.bytesGroupIdentifier;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged;
    }

    public PublishedDetails getNewPublishedDetails() {
        return this.newPublishedDetails;
    }

    public void setNewPublishedDetails(PublishedDetails newPublishedDetails) {
        this.newPublishedDetails = newPublishedDetails;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(Optional<String> name) {
        this.name = name.orElse(null);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(Optional<String> description) {
        this.description = description.orElse(null);
    }

    public Optional<String> getPhotoUrl() {
        return Optional.ofNullable(this.photoUrl);
    }

    public void setPhotoUrl(Optional<String> photoUrl) {
        this.photoUrl = photoUrl.orElse(null);
    }

    public Optional<String> getCustomName() {
        return Optional.ofNullable(this.customName);
    }

    public Optional<String> getGroupMembersNames() {
        return Optional.ofNullable(this.groupMembersNames);
    }

    public void setGroupMembersNames(Optional<String> groupMembersNames) {
        this.groupMembersNames = groupMembersNames.orElse(null);
    }

    public Optional<String> getCustomPhotoUrl() {
        return Optional.ofNullable(this.customPhotoUrl);
    }

    public Update getUpdateInProgress() {
        return this.updateInProgress;
    }

    public void setUpdateInProgress(Update updateInProgress) {
        this.updateInProgress = updateInProgress;
    }

    public Optional<String> getPersonalNote() {
        return Optional.ofNullable(this.personalNote);
    }

    public String toString() {
        return String.format("Group[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        GroupV10 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Arrays.equals(this.bytesGroupIdentifier, casted.bytesGroupIdentifier) && this.version == casted.version && this.keycloakManaged == casted.keycloakManaged && this.newPublishedDetails == casted.newPublishedDetails && Objects.equals(this.name, casted.name) && Objects.equals(this.description, casted.description) && Objects.equals(this.photoUrl, casted.photoUrl) && Objects.equals(this.customName, casted.customName) && Objects.equals(this.groupMembersNames, casted.groupMembersNames) && Objects.equals(this.customPhotoUrl, casted.customPhotoUrl) && this.updateInProgress == casted.updateInProgress && Objects.equals(this.personalNote, casted.personalNote);
    }

    @Override
    protected Class<GroupV10> getClazz() {
        return GroupV10.class;
    }

    public static enum Version implements IComparable<Version>
    {
        VERSION_1,
        VERSION_2;

    }

    public static enum PublishedDetails implements IComparable<PublishedDetails>
    {
        NOTHING_NEW,
        NEW_UNSEEN,
        NEW_SEEN,
        UNPUBLISHED_NEW;

    }

    public static enum Update implements IComparable<Update>
    {
        NONE,
        SYNCING,
        CREATING;

    }
}

