/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v10;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v10.ContactV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.GroupV10;
import io.olvid.windows.messenger.database.migrations.gen.v10.OwnedIdentityV10;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

@DatabaseTable(tableName="contact_group_join_table")
public class ContactGroupJoinV10
extends AbstractTableGenerated<ContactGroupJoinV10>
implements Table {
    public static final String TABLE_NAME = "contact_group_join_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<ContactGroupJoinV10, OwnedIdentityV10> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<ContactGroupJoinV10, ContactV10> FK_CONTACT = new Column.ForeignColumn("fk_contact", false);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<ContactGroupJoinV10, GroupV10> FK_GROUP = new Column.ForeignColumn("fk_group", false);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<ContactGroupJoinV10> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV10 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact NOT NULL REFERENCES contact_table(gen_id) ON DELETE CASCADE")
    protected ContactV10 fkContact;
    @DatabaseField(columnName="fk_group", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group NOT NULL REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected GroupV10 fkGroup;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public ContactGroupJoinV10() {
    }

    public ContactGroupJoinV10(long genId) {
        super(genId);
    }

    public ContactGroupJoinV10(long genId, OwnedIdentityV10 ownedIdentity, ContactV10 contact, GroupV10 group, long timestamp) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContact = contact;
        this.fkGroup = group;
        this.timestamp = timestamp;
    }

    public Id<OwnedIdentityV10> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Id<ContactV10> getContactId() {
        return this.fkContact.getItemId();
    }

    public Id<GroupV10> getGroupId() {
        return this.fkGroup.getItemId();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("ContactGroupJoin[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ContactGroupJoinV10 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContact, casted.fkContact) && Objects.equals(this.fkGroup, casted.fkGroup) && this.timestamp == casted.timestamp;
    }

    @Override
    protected Class<ContactGroupJoinV10> getClazz() {
        return ContactGroupJoinV10.class;
    }
}

