/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.DiscussionV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.InboundMessageV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.OutboundMessageV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.OwnedMessageV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="message_ref_table")
public class MessageRefV1
extends AbstractTableGenerated<MessageRefV1>
implements Table {
    public static final String TABLE_NAME = "message_ref_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<MessageRefV1, DiscussionV1> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<MessageRefV1> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<MessageRefV1, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String SENDER_IDENTIFIER_NAME = "sender_identifier";
    public static final Column.ObjectColumn<MessageRefV1, byte[]> SENDER_IDENTIFIER = new Column.ObjectColumn("sender_identifier", false);
    private static final String MESSAGE_HAS_BEEN_RECEIVED_NAME = "message_has_been_received";
    public static final Column.booleanColumn<MessageRefV1> MESSAGE_HAS_BEEN_RECEIVED = new Column.booleanColumn("message_has_been_received");
    private static final String FK_OUTBOUND_MESSAGE_NAME = "fk_outbound_message";
    public static final Column.ForeignColumn<MessageRefV1, OutboundMessageV1> FK_OUTBOUND_MESSAGE = new Column.ForeignColumn("fk_outbound_message", true);
    private static final String FK_INBOUND_MESSAGE_NAME = "fk_inbound_message";
    public static final Column.ForeignColumn<MessageRefV1, InboundMessageV1> FK_INBOUND_MESSAGE = new Column.ForeignColumn("fk_inbound_message", true);
    private static final String FK_OWNED_MESSAGE_NAME = "fk_owned_message";
    public static final Column.ForeignColumn<MessageRefV1, OwnedMessageV1> FK_OWNED_MESSAGE = new Column.ForeignColumn("fk_owned_message", true);
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV1 fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", uniqueCombo=true, dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="sender_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] senderIdentifier;
    @DatabaseField(columnName="message_has_been_received", dataType=DataType.BOOLEAN)
    protected boolean messageHasBeenReceived;
    @DatabaseField(columnName="fk_outbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message UNIQUE REFERENCES outbound_message_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessageV1 fkOutboundMessage;
    @DatabaseField(columnName="fk_inbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message UNIQUE REFERENCES inbound_message_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageV1 fkInboundMessage;
    @DatabaseField(columnName="fk_owned_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_message UNIQUE REFERENCES owned_message_table(gen_id) ON DELETE SET NULL")
    protected OwnedMessageV1 fkOwnedMessage;

    public MessageRefV1() {
    }

    public MessageRefV1(long genId) {
        super(genId);
    }

    public MessageRefV1(long genId, DiscussionV1 discussion, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier, boolean messageHasBeenReceived, OutboundMessageV1 outboundMessage, InboundMessageV1 inboundMessage, OwnedMessageV1 ownedMessage) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.senderIdentifier = senderIdentifier;
        this.messageHasBeenReceived = messageHasBeenReceived;
        this.fkOutboundMessage = outboundMessage;
        this.fkInboundMessage = inboundMessage;
        this.fkOwnedMessage = ownedMessage;
    }

    public Id<DiscussionV1> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public byte[] getSenderIdentifier() {
        return this.senderIdentifier;
    }

    public boolean isMessageHasBeenReceived() {
        return this.messageHasBeenReceived;
    }

    public Optional<Id<OutboundMessageV1>> getOutboundMessageId() {
        return Optional.ofNullable(this.fkOutboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<InboundMessageV1>> getInboundMessageId() {
        return Optional.ofNullable(this.fkInboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<OwnedMessageV1>> getOwnedMessageId() {
        return Optional.ofNullable(this.fkOwnedMessage).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("MessageRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRefV1 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && Arrays.equals(this.senderIdentifier, casted.senderIdentifier) && this.messageHasBeenReceived == casted.messageHasBeenReceived && Objects.equals(this.fkOutboundMessage, casted.fkOutboundMessage) && Objects.equals(this.fkInboundMessage, casted.fkInboundMessage) && Objects.equals(this.fkOwnedMessage, casted.fkOwnedMessage);
    }

    @Override
    protected Class<MessageRefV1> getClazz() {
        return MessageRefV1.class;
    }
}

