/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.DiscussionV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

public abstract class AbstractMessageV1<T extends AbstractMessageV1<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<AbstractMessageV1<?>, DiscussionV1> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<AbstractMessageV1<?>> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SORT_INDEX_NAME = "sort_index";
    public static final Column.doubleColumn<AbstractMessageV1<?>> SORT_INDEX = new Column.doubleColumn("sort_index");
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractMessageV1<?>> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_discussion", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV1 fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sort_index", dataType=DataType.DOUBLE)
    protected double sortIndex;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public AbstractMessageV1() {
    }

    protected AbstractMessageV1(long genId) {
        super(genId);
    }

    protected AbstractMessageV1(long genId, DiscussionV1 discussion, long senderSequenceNumber, double sortIndex, long timestamp) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.sortIndex = sortIndex;
        this.timestamp = timestamp;
    }

    public Id<DiscussionV1> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public double getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(double sortIndex) {
        this.sortIndex = sortIndex;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return String.format("AbstractMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractMessageV1 casted = (AbstractMessageV1)this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && this.sortIndex == casted.sortIndex && this.timestamp == casted.timestamp;
    }
}

