/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations;

import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.database.migrations.gen.Migration3To4Generated;
import io.olvid.windows.messenger.database.migrations.gen.v4.IdentityRefV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.attachment.AttachmentRecipientInfoV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.attachment.OutboundAttachmentV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.MessageRecipientInfoV4;
import io.olvid.windows.messenger.database.migrations.gen.v4.message.OutboundMessageV4;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class Migration3To4Impl
extends Migration3To4Generated {
    @Override
    public void setupMigration() throws Exception, SQLException {
        Id<AbstractTableGenerated> id;
        ObvUpdateBuilder<AbstractTableGenerated> updateBuilder;
        int count = 0;
        List<Migration3To4Generated.OutboundAttachmentV3Pojo> attachments = Migration3To4Generated.OutboundAttachmentV3Pojo.getAll(this.migrationDelegate);
        for (Migration3To4Generated.OutboundAttachmentV3Pojo attachment : attachments) {
            if (attachment.status() != Migration3To4Generated.OutboundAttachmentV3Pojo.Status.UPLOADED) continue;
            updateBuilder = this.getOutboundAttachmentDao().updateBuilder();
            id = new Id<OutboundAttachmentV4>(OutboundAttachmentV4.class, attachment.genId());
            updateBuilder.where().eq(OutboundAttachmentV4.GEN_ID, id);
            updateBuilder.updateColumnValue(OutboundAttachmentV4.STATUS, OutboundAttachmentV4.Status.SENT);
            if (updateBuilder.update() != 1) {
                throw new DbMigration.DbMigrationException("Couldn't update attachment = " + attachment.genId());
            }
            ++count;
        }
        this.logger.info("Migration3To4Impl::setupMigration: renamed " + count + " attachments status UPLOADED to SENT");
        count = 0;
        List<Migration3To4Generated.OutboundMessageV3Pojo> outboundMessages = Migration3To4Generated.OutboundMessageV3Pojo.getAll(this.migrationDelegate);
        for (Migration3To4Generated.OutboundMessageV3Pojo outboundMessage : outboundMessages) {
            switch (outboundMessage.status()) {
                case FAILED: 
                case UNDELIVERED: 
                case NO_CONTACT_RECIPIENTS: 
                case DRAFT: 
                case UNPROCESSED: 
                case PROCESSING: {
                    break;
                }
                case SENT: 
                case DELIVERED: 
                case READ: {
                    updateBuilder = this.getOutboundMessageDao().updateBuilder();
                    id = new Id<OutboundMessageV4>(OutboundMessageV4.class, outboundMessage.genId());
                    updateBuilder.where().eq(OutboundMessageV4.GEN_ID, id);
                    updateBuilder.updateColumnValue(OutboundMessageV4.STATUS, OutboundMessageV4.Status.UNPROCESSED);
                    if (updateBuilder.update() != 1) {
                        throw new DbMigration.DbMigrationException("Couldn't update message = " + outboundMessage.genId());
                    }
                    ++count;
                }
            }
        }
        this.logger.info("Migration3To4Impl::setupMigration: clear " + count + " outbound messages legacy statuses");
    }

    private void fillMissingMessageRecipientInfoStatus(Column.ObjectColumn<MessageRecipientInfoV4, Long> from, Column.ObjectColumn<MessageRecipientInfoV4, Long> to, Function<MessageRecipientInfoV4, Optional<Long>> fromValue) throws SQLException {
        int count = 0;
        ObvQueryBuilder queryBuilder = this.getMessageRecipientInfoDao().queryBuilder();
        queryBuilder.where().isNotNull(from).and().isNull(to);
        List infos = queryBuilder.query();
        for (MessageRecipientInfoV4 info : infos) {
            Optional<Long> fromOpt = fromValue.apply(info);
            if (fromOpt.isEmpty()) {
                this.logger.error("Migration3To4Impl::performMigration: " + from.name + " is null");
                continue;
            }
            ObvUpdateBuilder<MessageRecipientInfoV4> updateBuilder = this.getMessageRecipientInfoDao().updateBuilder();
            updateBuilder.where().eq(MessageRecipientInfoV4.GEN_ID, info.getItemId());
            updateBuilder.updateColumnValue(to, fromOpt.get());
            updateBuilder.update();
            ++count;
        }
        this.logger.info("Migration3To4Impl::performMigration: updated " + count + " message recipient info " + to.name);
    }

    private void fillAttachmentRecipientInfoMissingStatus(Column.ObjectColumn<AttachmentRecipientInfoV4, Long> from, Column.ObjectColumn<AttachmentRecipientInfoV4, Long> to, Function<AttachmentRecipientInfoV4, Optional<Long>> fromValue) throws SQLException {
        int count = 0;
        ObvQueryBuilder queryBuilder = this.getAttachmentRecipientInfoDao().queryBuilder();
        queryBuilder.where().isNotNull(from).and().isNull(to);
        List infos = queryBuilder.query();
        for (AttachmentRecipientInfoV4 info : infos) {
            Optional<Long> fromOpt = fromValue.apply(info);
            if (fromOpt.isEmpty()) {
                this.logger.error("Migration3To4Impl::performMigration: " + from.name + " is null");
                continue;
            }
            ObvUpdateBuilder<AttachmentRecipientInfoV4> updateBuilder = this.getAttachmentRecipientInfoDao().updateBuilder();
            updateBuilder.where().eq(AttachmentRecipientInfoV4.GEN_ID, info.getItemId());
            updateBuilder.updateColumnValue(to, fromOpt.get());
            updateBuilder.update();
            ++count;
        }
        this.logger.info("Migration3To4Impl::performMigration: updated " + count + " attachment recipient info " + to.name);
    }

    @Override
    public void performMigration() throws SQLException {
        this.logger.info("Migration3To4Impl::performMigration");
        this.fillMissingMessageRecipientInfoStatus(MessageRecipientInfoV4.TIMESTAMP_READ, MessageRecipientInfoV4.TIMESTAMP_DELIVERED, MessageRecipientInfoV4::getTimestampRead);
        this.fillMissingMessageRecipientInfoStatus(MessageRecipientInfoV4.TIMESTAMP_DELIVERED, MessageRecipientInfoV4.TIMESTAMP_SENT, MessageRecipientInfoV4::getTimestampDelivered);
        this.fillAttachmentRecipientInfoMissingStatus(AttachmentRecipientInfoV4.TIMESTAMP_READ, AttachmentRecipientInfoV4.TIMESTAMP_DELIVERED, AttachmentRecipientInfoV4::getTimestampRead);
        this.fillAttachmentRecipientInfoMissingStatus(AttachmentRecipientInfoV4.TIMESTAMP_DELIVERED, AttachmentRecipientInfoV4.TIMESTAMP_SENT, AttachmentRecipientInfoV4::getTimestampDelivered);
        ObvQueryBuilder queryBuilder = this.getOutboundMessageDao().queryBuilder();
        queryBuilder.where().eq(OutboundMessageV4.STATUS, OutboundMessageV4.Status.UNPROCESSED);
        List outboundMessages = queryBuilder.query();
        int count = 0;
        for (OutboundMessageV4 outboundMessage : outboundMessages) {
            if (!this.refreshOutboundStatus((Id<OutboundMessageV4>)outboundMessage.getItemId())) continue;
            ++count;
        }
        this.logger.info("Migration3To4Impl::performMigration: updated " + count + " outbound messages statuses");
    }

    private boolean refreshOutboundStatus(Id<OutboundMessageV4> messageId) throws SQLException {
        List<MessageRecipientInfoV4> messageRecipientInfos = this.getMessageRecipientInfoDao().queryBuilder().where().eq(MessageRecipientInfoV4.FK_MESSAGE, messageId).query();
        if (messageRecipientInfos.isEmpty()) {
            return false;
        }
        OutboundMessageV4 message = this.getOutboundMessageDao().get(messageId);
        if (message == null) {
            this.logger.error("MessageApi: refreshStatus: message not found " + String.valueOf(messageId));
            return false;
        }
        switch (message.getStatus()) {
            case FAILED: 
            case UNDELIVERED: 
            case NO_CONTACT_RECIPIENTS: 
            case DRAFT: {
                return false;
            }
        }
        OutboundMessageV4.Status newStatus = this.computeStatus(messageRecipientInfos);
        if (message.getStatus() == newStatus) {
            return false;
        }
        this.updateStatus(messageId, newStatus);
        return true;
    }

    private void updateStatus(Id<OutboundMessageV4> messageId, OutboundMessageV4.Status status) throws SQLException {
        ObvUpdateBuilder<OutboundMessageV4> updateBuilder = this.getOutboundMessageDao().updateBuilder();
        updateBuilder.where().eq(OutboundMessageV4.GEN_ID, messageId);
        updateBuilder.updateColumnValue(OutboundMessageV4.STATUS, status);
        updateBuilder.update();
    }

    public Optional<Long> getTimestamp(MessageRecipientInfoV4 info, Status status) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.empty();
            case 1 -> info.getTimestampSent();
            case 2 -> info.getTimestampDelivered();
            case 3 -> info.getTimestampRead();
        };
    }

    private boolean isInformationFromOtherOwnedDevice(MessageRecipientInfoV4 info) {
        Id<IdentityRefV4> recipientRefId = info.getRecipientRefId();
        IdentityRefV4 identityRef = this.getIdentityRefDao().get(recipientRefId);
        return identityRef.getOwnedIdentityId().isPresent();
    }

    private OutboundMessageV4.Status computeStatus(List<MessageRecipientInfoV4> infos) {
        int recipientCount = 0;
        int sentCount = 0;
        int deliveredCount = 0;
        int readCount = 0;
        for (MessageRecipientInfoV4 info : infos) {
            if (infos.size() > 1 && this.isInformationFromOtherOwnedDevice(info)) continue;
            ++recipientCount;
            if (this.getTimestamp(info, Status.SENT).isPresent()) {
                ++sentCount;
            }
            if (this.getTimestamp(info, Status.DELIVERED).isPresent()) {
                ++deliveredCount;
            }
            if (!this.getTimestamp(info, Status.READ).isPresent()) continue;
            ++readCount;
        }
        if (sentCount < recipientCount) {
            return OutboundMessageV4.Status.PROCESSING;
        }
        if (deliveredCount == 0) {
            return OutboundMessageV4.Status.SENT;
        }
        if (deliveredCount < recipientCount) {
            assert (recipientCount > 0);
            if (readCount == 0) {
                return OutboundMessageV4.Status.PARTIALLY_DELIVERED_NOT_READ;
            }
            assert (readCount < recipientCount);
            return OutboundMessageV4.Status.PARTIALLY_DELIVERED_PARTIALLY_READ;
        }
        assert (deliveredCount == recipientCount);
        if (readCount == 0) {
            if (recipientCount == 1) {
                return OutboundMessageV4.Status.DELIVERED;
            }
            return OutboundMessageV4.Status.FULLY_DELIVERED_NOT_READ;
        }
        if (readCount < recipientCount) {
            assert (recipientCount > 0);
            return OutboundMessageV4.Status.FULLY_DELIVERED_PARTIALLY_READ;
        }
        assert (readCount == recipientCount);
        if (recipientCount == 1) {
            return OutboundMessageV4.Status.DELIVERED_AND_READ;
        }
        return OutboundMessageV4.Status.FULLY_DELIVERED_FULLY_READ;
    }

    public static enum Status {
        PROCESSING,
        SENT,
        DELIVERED,
        READ;

    }
}

