/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.management;

import com.j256.ormlite.jdbc.JdbcSingleConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.dao.interfaces.IDaoManagerFacade;
import io.olvid.windows.messenger.logger.AppLogger;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class OlvidDaoManager
implements IDaoManagerFacade {
    private JdbcSingleConnectionSource singleConnectionSource;
    private final AppLogger loggerInstance = new AppLogger(this.getClass());
    final HashMap<String, OlvidAbstractDao<?>> registeredDaos = new HashMap();

    public OlvidDaoManager(String dbURL, Connection singleConnection) {
        try {
            this.singleConnectionSource = new JdbcSingleConnectionSource();
            this.singleConnectionSource.setSqlConnection(singleConnection);
            this.singleConnectionSource.setUrl(dbURL);
            this.singleConnectionSource.initialize();
            this.loggerInstance.debug("Created jdbc single connection successfully");
        }
        catch (SQLException throwables) {
            this.loggerInstance.error("Something wrong happened while creating jdbc pooled connections");
            this.loggerInstance.error(throwables.getMessage());
        }
        catch (Exception e) {
            this.loggerInstance.error(e.getMessage());
        }
    }

    @Override
    public ConnectionSource getConnectionSource() {
        return this.singleConnectionSource;
    }

    @Override
    public <TableType> OlvidAbstractDao<TableType> getDao(Class<TableType> tableType) {
        if (this.singleConnectionSource == null) {
            this.loggerInstance.error("ConnectionPool member or daoclass type arg is null...");
            return null;
        }
        return this.registeredDaos.get(tableType.getName());
    }

    @Override
    public <TableType> IDaoManagerFacade.DaoManagerOperationStatus registerDao(OlvidAbstractDao<TableType> dao) {
        if (this.checkArgs(dao)) {
            if (this.registeredDaos.get(dao.getDataClass().getName()) != null) {
                return IDaoManagerFacade.DaoManagerOperationStatus.DAO_REGISTERED;
            }
            try {
                TableUtils.createTableIfNotExists((ConnectionSource)this.singleConnectionSource, dao.getDataClass());
            }
            catch (SQLException throwables) {
                AppLogger.e("Couldn't create table " + dao.getDataClass().toString(), throwables);
                return IDaoManagerFacade.DaoManagerOperationStatus.DAO_NOT_REGISTERED;
            }
            this.getAndExecuteExtraStatements(dao);
            this.registeredDaos.put(dao.getDataClass().getName(), dao);
            return IDaoManagerFacade.DaoManagerOperationStatus.DAO_REGISTERED;
        }
        return IDaoManagerFacade.DaoManagerOperationStatus.BAD_ARGUMENT;
    }

    private <TableType> void getAndExecuteExtraStatements(OlvidAbstractDao<TableType> dao) {
        if (this.checkArgs(dao)) {
            try {
                Class<TableType> clazz = dao.getDataClass();
                Optional<Field> statementsMemberName = this.getExtraStatementsAnnotationValue(clazz);
                if (statementsMemberName.isPresent()) {
                    this.loggerInstance.info("Found extra statements");
                    List<String> statements = this.getStatementsList(statementsMemberName.get());
                    for (String statement : statements) {
                        this.loggerInstance.info("Executing : %s", statement);
                        dao.executeRaw(statement, new String[0]);
                    }
                }
            }
            catch (SQLException throwables) {
                AppLogger.e("Couldn't execute extra statements with DAO : " + dao.getDataClass().toString(), throwables);
            }
            catch (NoSuchFieldException e) {
                AppLogger.e("Couldn't get extra statement member associated to table " + dao.getDataClass().toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Optional<Field> getExtraStatementsAnnotationValue(Class<?> clazz) {
        if (Arrays.stream(clazz.getFields()).noneMatch(field -> field.isAnnotationPresent(ExtraStatements.class))) {
            if (clazz.getSuperclass() != null) {
                this.getExtraStatementsAnnotationValue(clazz.getSuperclass());
            } else {
                return Optional.empty();
            }
        }
        return Arrays.stream(clazz.getFields()).filter(field -> field.isAnnotationPresent(ExtraStatements.class)).findFirst();
    }

    private List<String> getStatementsList(Field listMemberNameField) throws NoSuchFieldException, IllegalAccessException {
        Object toto1;
        ArrayList<String> statements = new ArrayList<String>();
        if (List.class.isAssignableFrom(listMemberNameField.getType()) && (toto1 = listMemberNameField.get(statements)) instanceof List) {
            List real = (List)toto1;
            for (Object obj : real) {
                if (!(obj instanceof String)) continue;
                String statement = (String)obj;
                statements.add(statement);
            }
        }
        return statements;
    }

    @Override
    public <TableType> IDaoManagerFacade.DaoManagerOperationStatus unregisterDao(OlvidAbstractDao<TableType> dao) {
        this.checkArgs(dao);
        this.registeredDaos.remove(dao.getDataClass().getName(), dao);
        if (this.registeredDaos.get(dao.getDataClass().getName()) == null) {
            this.loggerInstance.debug("Dao Unregistered successfully");
            return IDaoManagerFacade.DaoManagerOperationStatus.DAO_UNREGISTERED;
        }
        this.loggerInstance.error("Dao Still Registered");
        return IDaoManagerFacade.DaoManagerOperationStatus.DAO_NOT_UNREGISTERED;
    }

    public ConnectionSource getSingleConnectionSource() {
        return this.singleConnectionSource;
    }

    @Override
    public void clearDaoManagerCache() {
        this.loggerInstance.debug("Clearing DaoManager Cache");
        if (this.registeredDaos != null) {
            this.registeredDaos.clear();
        }
    }

    private boolean checkArgs(OlvidAbstractDao<?> dao) {
        if (this.singleConnectionSource == null || dao == null) {
            this.loggerInstance.error("Dao arg is null...");
            return false;
        }
        return true;
    }

    public void clearConnections() {
        this.singleConnectionSource.close();
    }
}

