/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.management;

import com.j256.ormlite.dao.DatabaseResultsMapper;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.misc.TransactionManager;
import io.olvid.windows.messenger.database.dao.AppDbSchemaVersionDao;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.dao.interfaces.IDaoManagerFacade;
import io.olvid.windows.messenger.database.management.AbstractDbManager;
import io.olvid.windows.messenger.database.management.MigrationsProviderImpl;
import io.olvid.windows.messenger.database.management.MigrationsRegister;
import io.olvid.windows.messenger.database.management.gen.AppSchemaVersion;
import io.olvid.windows.messenger.database.management.gen.MigrationsProvider;
import io.olvid.windows.messenger.database.migrations.AbstractMigration;
import io.olvid.windows.messenger.database.migrations.MigrationDelegate;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;

public final class DbMigration
extends AbstractDbManager
implements MigrationDelegate {
    private final MigrationsProvider migrationsProvider = new MigrationsProviderImpl();
    private final MigrationsRegister migrationsRegister = new MigrationsRegister(this.migrationsProvider);

    public static Optional<AppSchemaVersion> next(AppSchemaVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case AppSchemaVersion.VERSION_0 -> Optional.of(AppSchemaVersion.VERSION_1);
            case AppSchemaVersion.VERSION_1 -> Optional.of(AppSchemaVersion.VERSION_2);
            case AppSchemaVersion.VERSION_2 -> Optional.of(AppSchemaVersion.VERSION_3);
            case AppSchemaVersion.VERSION_3 -> Optional.of(AppSchemaVersion.VERSION_4);
            case AppSchemaVersion.VERSION_4 -> Optional.of(AppSchemaVersion.VERSION_5);
            case AppSchemaVersion.VERSION_5 -> Optional.of(AppSchemaVersion.VERSION_6);
            case AppSchemaVersion.VERSION_6 -> Optional.of(AppSchemaVersion.VERSION_7);
            case AppSchemaVersion.VERSION_7 -> Optional.of(AppSchemaVersion.VERSION_8);
            case AppSchemaVersion.VERSION_8 -> Optional.of(AppSchemaVersion.VERSION_9);
            case AppSchemaVersion.VERSION_9 -> Optional.of(AppSchemaVersion.VERSION_10);
            case AppSchemaVersion.VERSION_10 -> Optional.empty();
        };
    }

    public DbMigration() {
        try {
            Properties props = new Properties();
            props.setProperty("journal_mode", "WAL");
            props.setProperty("foreign_keys", "OFF");
            this.configure(Optional.of(props));
        }
        catch (SQLException throwables) {
            this.loggerInstance.error("Unable to configure DbMigration", throwables);
        }
    }

    public <TableType> IDaoManagerFacade.DaoManagerOperationStatus registerDao(OlvidAbstractDao<TableType> dao) {
        return this.olvidDaoManager.registerDao(dao);
    }

    @Override
    public <T> IDaoManagerFacade.DaoManagerOperationStatus unregisterDao(OlvidAbstractDao<T> dao) {
        return this.olvidDaoManager.unregisterDao(dao);
    }

    @Override
    public Collection<OlvidAbstractDao<?>> getAllDao() {
        return this.olvidDaoManager.registeredDaos.values();
    }

    @Override
    public int executeRaw(String statement, String ... arguments) throws SQLException {
        return this.getAppDbSchemaVersionDao().executeRaw(statement, arguments);
    }

    @Override
    public <UO> GenericRawResults<UO> queryRaw(String query, DatabaseResultsMapper<UO> mapper) throws SQLException {
        return this.getAppDbSchemaVersionDao().queryRaw(query, mapper);
    }

    @Override
    public void registerDaos() throws SQLException {
        this.olvidDaoManager.registerDao(new AppDbSchemaVersionDao(this.olvidDaoManager.getConnectionSource()));
    }

    private void doPerformMigration() throws Exception {
        Optional<AppSchemaVersion> currentVersionOpt;
        AppDbSchemaVersionDao appDbSchemaVersionDao = this.getAppDbSchemaVersionDao();
        AppSchemaVersion current = AppSchemaVersion.current;
        AppLogger.i("DbMigration: Start App Migration");
        AppLogger.i("DbMigration: Expected App Schema: " + AppSchemaVersion.current.name());
        try {
            currentVersionOpt = appDbSchemaVersionDao.getCurrentVersion();
        }
        catch (SQLException e) {
            AppLogger.e("DbMigration: Cannot get current app schema. Maybe you are running a former application version with a recent database?");
            throw e;
        }
        if (currentVersionOpt.isEmpty()) {
            AppLogger.i("DbMigration: First run, no version in database");
            try {
                appDbSchemaVersionDao.updateAppDbSchemaVersion(current);
                AppLogger.i(String.format("DbMigration: Store version %s is database", current.name()));
            }
            catch (SQLException e) {
                AppLogger.e("DbMigration: Cannot update Current App Schema", e);
                return;
            }
            AppLogger.i("DbMigration: No need to perform migration");
            return;
        }
        AppSchemaVersion currentVersion = currentVersionOpt.get();
        AppLogger.i("DbMigration: Current App Schema: " + currentVersion.name());
        if (currentVersion == current) {
            AppLogger.i("DbMigration: No need to perform migration");
            return;
        }
        AppLogger.i(String.format("DbMigration: Need to perform migration from %s to %s", currentVersion.name(), current.name()));
        this.performMigrations(currentVersion, current);
        AppLogger.i(String.format("DbMigration: Migration from %s to %s succeed", currentVersion.name(), current.name()));
    }

    public void performMigration() throws SQLException {
        TransactionManager transactionManager = new TransactionManager(this.getConnectionSource());
        transactionManager.callInTransaction(() -> {
            this.doPerformMigration();
            return null;
        });
    }

    public void dispose() {
        this.migrationsRegister.dispose();
        this.olvidDaoManager.clearConnections();
        try {
            this.close();
        }
        catch (Exception e) {
            AppLogger.e("Cannot close DBMigration connection", e);
        }
    }

    private void performMigrations(AppSchemaVersion currentVersion, AppSchemaVersion expectedVersion) throws Exception {
        AppSchemaVersion current = currentVersion;
        while (DbMigration.next(current).isPresent()) {
            AppSchemaVersion next = DbMigration.next(current).get();
            Optional<AbstractMigration> migrationOpt = this.migrationsRegister.getMigrationFrom(current);
            if (migrationOpt.isEmpty()) {
                throw new DbMigrationException(String.format("DbMigration: Missing migration from %s", current.name()));
            }
            AbstractMigration migration = migrationOpt.get();
            if (migration.to != next) {
                throw new DbMigrationException(String.format("State is incoherent: migration.to:(%s) != current.next(%s)", migration.to.name(), next.name()));
            }
            AppLogger.i(String.format("DbMigration: Start migration from %s to %s", current.name(), next.name()));
            migration.migrationDelegate = this;
            migration.registerDaos();
            migration.saveForeignConstraints();
            migration.setupMigration();
            migration.performMigration();
            migration.verifyMigration();
            migration.unregisterDaos();
            if (next == expectedVersion) break;
            current = next;
        }
        this.getAppDbSchemaVersionDao().updateAppDbSchemaVersion(expectedVersion);
    }

    public static class DbMigrationException
    extends Exception {
        public DbMigrationException(String message) {
            super(message);
        }

        public DbMigrationException(Exception e) {
            super(e);
        }

        public DbMigrationException(String message, Exception e) {
            super(message, e);
        }
    }
}

