/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.management;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.j256.ormlite.support.ConnectionSource;
import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.engine.secure_io.SeedHandler;
import io.olvid.windows.messenger.configuration.AppDatabaseConfiguration;
import io.olvid.windows.messenger.database.dao.AppDbSchemaVersionDao;
import io.olvid.windows.messenger.database.dao.ApplicationSettingDao;
import io.olvid.windows.messenger.database.dao.CapabilitiesDao;
import io.olvid.windows.messenger.database.dao.ContactDao;
import io.olvid.windows.messenger.database.dao.ContactGroupJoinDao;
import io.olvid.windows.messenger.database.dao.ContactRefDao;
import io.olvid.windows.messenger.database.dao.DiscussionCustomizationDao;
import io.olvid.windows.messenger.database.dao.DiscussionDao;
import io.olvid.windows.messenger.database.dao.FyleDao;
import io.olvid.windows.messenger.database.dao.GroupDao;
import io.olvid.windows.messenger.database.dao.GroupMemberPermissionsDao;
import io.olvid.windows.messenger.database.dao.IdentityDetailsDao;
import io.olvid.windows.messenger.database.dao.IdentityRefDao;
import io.olvid.windows.messenger.database.dao.InvitationsDao;
import io.olvid.windows.messenger.database.dao.KnownCertificateDao;
import io.olvid.windows.messenger.database.dao.LocationDao;
import io.olvid.windows.messenger.database.dao.OwnedDeviceDao;
import io.olvid.windows.messenger.database.dao.OwnedIdentityDao;
import io.olvid.windows.messenger.database.dao.PendingGroupMemberDao;
import io.olvid.windows.messenger.database.dao.PreContactDao;
import io.olvid.windows.messenger.database.dao.PreGroupDao;
import io.olvid.windows.messenger.database.dao.StartupJobDao;
import io.olvid.windows.messenger.database.dao.attachment.AttachmentRecipientInfoDao;
import io.olvid.windows.messenger.database.dao.attachment.InboundAttachmentDao;
import io.olvid.windows.messenger.database.dao.attachment.OutboundAttachmentDao;
import io.olvid.windows.messenger.database.dao.attachment.OwnedAttachmentDao;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.dao.ephemerality.InboundMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.ephemerality.OutboundMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.ephemerality.OwnedMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.InboundMessageDao;
import io.olvid.windows.messenger.database.dao.message.InboundMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.dao.message.MessageRecipientInfoDao;
import io.olvid.windows.messenger.database.dao.message.MessageRefDao;
import io.olvid.windows.messenger.database.dao.message.OutboundMessageDao;
import io.olvid.windows.messenger.database.dao.message.OwnedMessageDao;
import io.olvid.windows.messenger.database.dao.message.OwnedMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.dao.message.PendingMessageDao;
import io.olvid.windows.messenger.database.dao.message.SystemMessageDao;
import io.olvid.windows.messenger.database.dao.metadata.InboundMessageMetadataDao;
import io.olvid.windows.messenger.database.dao.metadata.OutboundMessageMetadataDao;
import io.olvid.windows.messenger.database.dao.metadata.OwnedMessageMetadataDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageChoiceDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageVoteDao;
import io.olvid.windows.messenger.database.dao.reaction.InboundMessageReactionDao;
import io.olvid.windows.messenger.database.dao.reaction.OutboundMessageReactionDao;
import io.olvid.windows.messenger.database.dao.reaction.OwnedMessageReactionDao;
import io.olvid.windows.messenger.database.dao.remoterequest.ReactionRequestDao;
import io.olvid.windows.messenger.database.dao.remoterequest.RemoteDeleteRequestDao;
import io.olvid.windows.messenger.database.dao.remoterequest.RemoteEditRequestDao;
import io.olvid.windows.messenger.database.management.OlvidDaoManager;
import io.olvid.windows.messenger.database.tables.AppDbSchemaVersion;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.KnownCertificate;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.StartupJob;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.InboundMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteDeleteRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteEditRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteReactionRequest;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;

public abstract class AbstractDbManager {
    protected final AppLogger loggerInstance;
    protected OlvidDaoManager olvidDaoManager;
    protected static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    private Properties connectionProps = new Properties();
    private Connection singleConnection;

    protected AbstractDbManager() {
        this.loggerInstance = new AppLogger(this.getClass());
    }

    protected boolean configure(Optional<Properties> props) throws SQLException {
        props.ifPresent(properties -> {
            this.connectionProps = properties;
        });
        String appDbKey = KeyManagerSingleton.getInstance().getDbEncryptionKey(SeedHandler.EncryptionSeedType.APP_DATABASE);
        if (AppRuntimeHelper.isDebugMode) {
            this.loggerInstance.info("App DB key : " + appDbKey);
        }
        if (AppRuntimeHelper.isDataBaseEncrypted) {
            this.connectionProps.setProperty("password", appDbKey);
        }
        this.singleConnection = DriverManager.getConnection(AppDatabaseConfiguration.getInstance().getDbURL(), this.connectionProps);
        this.singleConnection.beginRequest();
        this.loggerInstance.debug("Connection to app db successful");
        this.olvidDaoManager = new OlvidDaoManager(AppDatabaseConfiguration.getInstance().getDbURL(), this.singleConnection);
        this.registerDaos();
        return true;
    }

    public ConnectionSource getConnectionSource() {
        return this.olvidDaoManager.getConnectionSource();
    }

    public void close() throws SQLException {
        this.singleConnection.close();
    }

    public OwnedIdentityDao getOwnedIdentityDao() {
        return (OwnedIdentityDao)this.getDao(OwnedIdentity.class);
    }

    public InvitationsDao getInvitationDao() {
        return (InvitationsDao)this.getDao(Invitation.class);
    }

    public ContactDao getContactDao() {
        return (ContactDao)this.getDao(Contact.class);
    }

    public GroupMemberPermissionsDao getGroupMemberPermissionsDao() {
        return (GroupMemberPermissionsDao)this.getDao(GroupMemberPermissions.class);
    }

    public GroupDao getGroupDao() {
        return (GroupDao)this.getDao(Group.class);
    }

    public DiscussionDao getDiscussionDao() {
        return (DiscussionDao)this.getDao(Discussion.class);
    }

    public MessageRecipientInfoDao getMessageRecipientInfoDao() {
        return (MessageRecipientInfoDao)this.getDao(MessageRecipientInfo.class);
    }

    public AttachmentRecipientInfoDao getAttachmentRecipientInfoDao() {
        return (AttachmentRecipientInfoDao)this.getDao(AttachmentRecipientInfo.class);
    }

    public ContactGroupJoinDao getContactGroupJoinDao() {
        return (ContactGroupJoinDao)this.getDao(ContactGroupJoin.class);
    }

    public PendingGroupMemberDao getPendingGroupMemberDao() {
        return (PendingGroupMemberDao)this.getDao(PendingGroupMember.class);
    }

    public FyleDao getFyleDao() {
        return (FyleDao)this.getDao(Fyle.class);
    }

    public InboundAttachmentDao getInboundAttachmentDao() {
        return (InboundAttachmentDao)this.getDao(InboundAttachment.class);
    }

    public OutboundAttachmentDao getOutboundAttachmentDao() {
        return (OutboundAttachmentDao)this.getDao(OutboundAttachment.class);
    }

    public OwnedAttachmentDao getOwnedAttachmentDao() {
        return (OwnedAttachmentDao)this.getDao(OwnedAttachment.class);
    }

    public DiscussionCustomizationDao getDiscussionCustomizationDao() {
        return (DiscussionCustomizationDao)this.getDao(DiscussionCustomization.class);
    }

    public InboundMessageMetadataDao getInboundMessageMetadataDao() {
        return (InboundMessageMetadataDao)this.getDao(InboundMessageMetadata.class);
    }

    public OutboundMessageMetadataDao getOutboundMessageMetadataDao() {
        return (OutboundMessageMetadataDao)this.getDao(OutboundMessageMetadata.class);
    }

    public OwnedMessageMetadataDao getOwnedMessageMetadataDao() {
        return (OwnedMessageMetadataDao)this.getDao(OwnedMessageMetadata.class);
    }

    public OutboundMessageEphemeralInfoDao getOutboundMessageEphemeralInfoDao() {
        return (OutboundMessageEphemeralInfoDao)this.getDao(OutboundMessageEphemeralInfo.class);
    }

    public InboundMessageEphemeralInfoDao getInboundMessageEphemeralInfoDao() {
        return (InboundMessageEphemeralInfoDao)this.getDao(InboundMessageEphemeralInfo.class);
    }

    public OwnedMessageEphemeralInfoDao getOwnedMessageEphemeralInfoDao() {
        return (OwnedMessageEphemeralInfoDao)this.getDao(OwnedMessageEphemeralInfo.class);
    }

    public ApplicationSettingDao getApplicationSettingsDao() {
        return (ApplicationSettingDao)this.getDao(ApplicationSetting.class);
    }

    public KnownCertificateDao getKnownCertificateDao() {
        return (KnownCertificateDao)this.getDao(KnownCertificate.class);
    }

    public RemoteDeleteRequestDao getRemoteDeleteRequestDao() {
        return (RemoteDeleteRequestDao)this.getDao(RemoteDeleteRequest.class);
    }

    public RemoteEditRequestDao getRemoteEditRequestDao() {
        return (RemoteEditRequestDao)this.getDao(RemoteEditRequest.class);
    }

    public ReactionRequestDao getReactionRequestDao() {
        return (ReactionRequestDao)this.getDao(RemoteReactionRequest.class);
    }

    public InboundMessageReactionDao getInboundMessageReactionDao() {
        return (InboundMessageReactionDao)this.getDao(InboundMessageReaction.class);
    }

    public OutboundMessageReactionDao getOutboundMessageReactionDao() {
        return (OutboundMessageReactionDao)this.getDao(OutboundMessageReaction.class);
    }

    public OwnedMessageReactionDao getOwnedMessageReactionDao() {
        return (OwnedMessageReactionDao)this.getDao(OwnedMessageReaction.class);
    }

    public AppDbSchemaVersionDao getAppDbSchemaVersionDao() {
        return (AppDbSchemaVersionDao)this.getDao(AppDbSchemaVersion.class);
    }

    public IdentityRefDao getIdentityRefDao() {
        return (IdentityRefDao)this.getDao(IdentityRef.class);
    }

    public ContactRefDao getContactRefDao() {
        return (ContactRefDao)this.getDao(ContactRef.class);
    }

    public CapabilitiesDao getCapabilitiesDao() {
        return (CapabilitiesDao)this.getDao(Capabilities.class);
    }

    public IdentityDetailsDao getIdentityDetailsDao() {
        return (IdentityDetailsDao)this.getDao(IdentityDetails.class);
    }

    public SystemMessageDao getSystemMessageDao() {
        return (SystemMessageDao)this.getDao(SystemMessage.class);
    }

    public OutboundMessageDao getOutboundMessageDao() {
        return (OutboundMessageDao)this.getDao(OutboundMessage.class);
    }

    public InboundMessageDao getInboundMessageDao() {
        return (InboundMessageDao)this.getDao(InboundMessage.class);
    }

    public OwnedMessageDao getOwnedMessageDao() {
        return (OwnedMessageDao)this.getDao(OwnedMessage.class);
    }

    public MessageRefDao getMessageRefDao() {
        return (MessageRefDao)this.getDao(MessageRef.class);
    }

    public LocationDao getLocationDao() {
        return (LocationDao)this.getDao(Location.class);
    }

    public PreContactDao getPreContactDao() {
        return (PreContactDao)this.getDao(PreContact.class);
    }

    public PreGroupDao getPreGroupDao() {
        return (PreGroupDao)this.getDao(PreGroup.class);
    }

    public PendingMessageDao getPendingMessageDao() {
        return (PendingMessageDao)this.getDao(PendingMessage.class);
    }

    public OwnedDeviceDao getOwnedDeviceDao() {
        return (OwnedDeviceDao)this.getDao(OwnedDevice.class);
    }

    public StartupJobDao getStartupJobDao() {
        return (StartupJobDao)this.getDao(StartupJob.class);
    }

    public InboundMessageSequenceIntervalDao getInboundMessageSequenceIntervalDao() {
        return (InboundMessageSequenceIntervalDao)this.getDao(InboundMessageSequenceInterval.class);
    }

    public OwnedMessageSequenceIntervalDao getOwnedMessageSequenceIntervalDao() {
        return (OwnedMessageSequenceIntervalDao)this.getDao(OwnedMessageSequenceInterval.class);
    }

    public PollMessageDao getPollMessageDao() {
        return (PollMessageDao)this.getDao(PollMessage.class);
    }

    public PollMessageChoiceDao getPollMessageOptionDao() {
        return (PollMessageChoiceDao)this.getDao(PollMessageChoice.class);
    }

    public PollMessageVoteDao getPollMessageVoteDao() {
        return (PollMessageVoteDao)this.getDao(PollMessageVote.class);
    }

    public ObjectMapper getJsonObjectMapper() {
        return jsonObjectMapper;
    }

    public <Table> OlvidAbstractDao<Table> getDao(Class<Table> tableType) {
        return this.olvidDaoManager.getDao(tableType);
    }

    public void registerDaos() throws SQLException {
        this.olvidDaoManager.registerDao(new OwnedIdentityDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InvitationsDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new ContactDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new DiscussionDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new MessageRecipientInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new GroupDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new GroupMemberPermissionsDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new ContactGroupJoinDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PendingGroupMemberDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new FyleDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundAttachmentDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new AttachmentRecipientInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OutboundAttachmentDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedAttachmentDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new DiscussionCustomizationDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundMessageMetadataDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OutboundMessageMetadataDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageMetadataDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OutboundMessageEphemeralInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundMessageEphemeralInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageEphemeralInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageEphemeralInfoDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new ApplicationSettingDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new KnownCertificateDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new RemoteDeleteRequestDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new RemoteEditRequestDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundMessageReactionDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OutboundMessageReactionDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageReactionDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new ReactionRequestDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new AppDbSchemaVersionDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new IdentityRefDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new ContactRefDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new CapabilitiesDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new IdentityDetailsDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new SystemMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OutboundMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new MessageRefDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new LocationDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PreContactDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PreGroupDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PendingMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedDeviceDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new StartupJobDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new InboundMessageSequenceIntervalDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new OwnedMessageSequenceIntervalDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PollMessageDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PollMessageChoiceDao(this.olvidDaoManager.getConnectionSource()));
        this.olvidDaoManager.registerDao(new PollMessageVoteDao(this.olvidDaoManager.getConnectionSource()));
    }

    static {
        jsonObjectMapper.writerWithDefaultPrettyPrinter();
    }
}

