/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonOneToOneMessageIdentifier;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import java.util.Arrays;

public class JsonQuerySharedSettings {
    public byte[] groupUid;
    public byte[] groupOwner;
    byte[] groupV2Identifier;
    public JsonOneToOneMessageIdentifier oneToOneIdentifier;
    Integer knownSharedSettingsVersion;
    JsonExpiration knownSharedExpiration;

    public static JsonQuerySharedSettings of(Discussion discussion) throws Exception {
        JsonQuerySharedSettings jsonQuerySharedSettings = new JsonQuerySharedSettings();
        if (discussion != null) {
            if (discussion.getGroupId().isPresent()) {
                Group group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get());
                if (group.isV2()) {
                    jsonQuerySharedSettings.setGroupV2Identifier(group.getBytesGroupIdentifier());
                } else {
                    jsonQuerySharedSettings.setGroupOwnerAndUid(group.getBytesGroupIdentifier());
                }
            } else if (discussion.getContactId().isPresent()) {
                OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
                Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
                jsonQuerySharedSettings.oneToOneIdentifier = new JsonOneToOneMessageIdentifier(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
            }
        }
        return jsonQuerySharedSettings;
    }

    @JsonProperty(value="guid")
    public byte[] getGroupUid() {
        return this.groupUid;
    }

    @JsonProperty(value="guid")
    public void setGroupUid(byte[] groupUid) {
        this.groupUid = groupUid;
    }

    @JsonProperty(value="go")
    public byte[] getGroupOwner() {
        return this.groupOwner;
    }

    @JsonProperty(value="go")
    public void setGroupOwner(byte[] groupOwner) {
        this.groupOwner = groupOwner;
    }

    @JsonProperty(value="gid2")
    public byte[] getGroupV2Identifier() {
        return this.groupV2Identifier;
    }

    @JsonProperty(value="gid2")
    public void setGroupV2Identifier(byte[] groupV2Identifier) {
        this.groupV2Identifier = groupV2Identifier;
    }

    @JsonProperty(value="o2oi")
    public JsonOneToOneMessageIdentifier getOneToOneIdentifier() {
        return this.oneToOneIdentifier;
    }

    @JsonProperty(value="o2oi")
    public void setOneToOneIdentifier(JsonOneToOneMessageIdentifier oneToOneIdentifier) {
        this.oneToOneIdentifier = oneToOneIdentifier;
    }

    @JsonProperty(value="ksv")
    public Integer getKnownSharedSettingsVersion() {
        return this.knownSharedSettingsVersion;
    }

    @JsonProperty(value="ksv")
    public void setKnownSharedSettingsVersion(Integer knownSharedSettingsVersion) {
        this.knownSharedSettingsVersion = knownSharedSettingsVersion;
    }

    @JsonProperty(value="exp")
    public JsonExpiration getKnownSharedExpiration() {
        return this.knownSharedExpiration;
    }

    @JsonProperty(value="exp")
    public void setKnownSharedExpiration(JsonExpiration knownSharedExpiration) {
        this.knownSharedExpiration = knownSharedExpiration;
    }

    @JsonIgnore
    public void setGroupOwnerAndUid(byte[] bytesGroupOwnerAndUid) throws Exception {
        if (bytesGroupOwnerAndUid.length < 32) {
            throw new Exception();
        }
        byte[] bytesGroupOwner = Arrays.copyOfRange(bytesGroupOwnerAndUid, 0, bytesGroupOwnerAndUid.length - 32);
        byte[] bytesGroupUid = Arrays.copyOfRange(bytesGroupOwnerAndUid, bytesGroupOwnerAndUid.length - 32, bytesGroupOwnerAndUid.length);
        this.setGroupOwner(bytesGroupOwner);
        this.setGroupUid(bytesGroupUid);
    }
}

