/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.datatypes.json.JsonOneToOneMessageIdentifier;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import java.util.Arrays;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonPollVote {
    @JsonProperty(value="pcuid")
    public UUID pollCandidateUuid;
    @JsonProperty(value="v")
    public Boolean voted;
    @JsonProperty(value="ver")
    public Integer version;
    @JsonProperty(value="guid")
    public byte[] groupUid;
    @JsonProperty(value="go")
    public byte[] groupOwner;
    @JsonProperty(value="gid2")
    public byte[] groupV2Identifier;
    @JsonProperty(value="o2oi")
    public JsonOneToOneMessageIdentifier oneToOneIdentifier;
    @JsonProperty(value="ref")
    public JsonMessageReference messageReference;

    public static JsonPollVote of(Discussion discussion, AbstractUserMessageGenerated<?> message) throws Exception {
        JsonPollVote jsonPollVote = new JsonPollVote();
        jsonPollVote.messageReference = JsonMessageReference.of(message);
        if (discussion == null) {
            return jsonPollVote;
        }
        if (discussion.getGroupId().isPresent()) {
            Group group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get());
            if (group.isV2()) {
                jsonPollVote.groupV2Identifier = group.getBytesGroupIdentifier();
            } else {
                jsonPollVote.setGroupOwnerAndUid(group.getBytesGroupIdentifier());
            }
        } else if (discussion.getContactId().isPresent()) {
            Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
            OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
            jsonPollVote.oneToOneIdentifier = new JsonOneToOneMessageIdentifier(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
        }
        return jsonPollVote;
    }

    @JsonIgnore
    public void setGroupOwnerAndUid(byte[] bytesGroupOwnerAndUid) throws Exception {
        if (bytesGroupOwnerAndUid.length < 32) {
            throw new Exception();
        }
        byte[] bytesGroupOwner = Arrays.copyOfRange(bytesGroupOwnerAndUid, 0, bytesGroupOwnerAndUid.length - 32);
        byte[] bytesGroupUid = Arrays.copyOfRange(bytesGroupOwnerAndUid, bytesGroupOwnerAndUid.length - 32, bytesGroupOwnerAndUid.length);
        this.groupOwner = bytesGroupOwner;
        this.groupUid = bytesGroupUid;
    }
}

