/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.datatypes.json.JsonOneToOneMessageIdentifier;
import io.olvid.windows.messenger.database.datatypes.json.JsonPoll;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonMessage {
    public String body;
    public long senderSequenceNumber;
    public UUID senderThreadIdentifier;
    byte[] groupUid;
    byte[] groupOwner;
    byte[] groupV2Identifier;
    JsonOneToOneMessageIdentifier oneToOneIdentifier;
    Boolean forwarded;
    public JsonMessageReference jsonReply;
    public JsonExpiration jsonExpiration;
    public JsonLocation jsonLocation;
    public Long originalServerTimestamp;
    public JsonPoll jsonPoll;

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty(value="ssn")
    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    @JsonProperty(value="ssn")
    public void setSenderSequenceNumber(long senderSequenceNumber) {
        this.senderSequenceNumber = senderSequenceNumber;
    }

    @JsonProperty(value="sti")
    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    @JsonProperty(value="sti")
    public void setSenderThreadIdentifier(UUID senderThreadIdentifier) {
        this.senderThreadIdentifier = senderThreadIdentifier;
    }

    @JsonProperty(value="guid")
    public byte[] getGroupUid() {
        return this.groupUid;
    }

    @JsonProperty(value="guid")
    public void setGroupUid(byte[] groupUid) {
        this.groupUid = groupUid;
    }

    @JsonProperty(value="gid2")
    public byte[] getGroupV2Identifier() {
        return this.groupV2Identifier;
    }

    @JsonProperty(value="gid2")
    public void setGroupV2Identifier(byte[] groupV2Identifier) {
        this.groupV2Identifier = groupV2Identifier;
    }

    @JsonProperty(value="go")
    public byte[] getGroupOwner() {
        return this.groupOwner;
    }

    @JsonProperty(value="go")
    public void setGroupOwner(byte[] groupOwner) {
        this.groupOwner = groupOwner;
    }

    @JsonProperty(value="fw")
    public Boolean isForwarded() {
        return this.forwarded != null && this.forwarded != false;
    }

    @JsonProperty(value="fw")
    public void setForwarded(Boolean forwarded) {
        this.forwarded = forwarded;
    }

    @JsonProperty(value="re")
    public JsonMessageReference getJsonReply() {
        return this.jsonReply;
    }

    @JsonProperty(value="re")
    public void setJsonReply(JsonMessageReference jsonMessageReference) {
        this.jsonReply = jsonMessageReference;
    }

    @JsonProperty(value="exp")
    public JsonExpiration getJsonExpiration() {
        return this.jsonExpiration;
    }

    @JsonProperty(value="exp")
    public void setJsonExpiration(JsonExpiration jsonExpiration) {
        this.jsonExpiration = jsonExpiration;
    }

    @JsonProperty(value="loc")
    public JsonLocation getJsonLocation() {
        return this.jsonLocation;
    }

    @JsonProperty(value="loc")
    public void setJsonLocation(JsonLocation jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    @JsonProperty(value="ost")
    public Long getOriginalServerTimestamp() {
        return this.originalServerTimestamp;
    }

    @JsonProperty(value="ost")
    public void setOriginalServerTimestamp(Long originalServerTimestamp) {
        this.originalServerTimestamp = originalServerTimestamp;
    }

    @JsonProperty(value="o2oi")
    public JsonOneToOneMessageIdentifier getOneToOneIdentifier() {
        return this.oneToOneIdentifier;
    }

    @JsonProperty(value="o2oi")
    public void setOneToOneIdentifier(JsonOneToOneMessageIdentifier oneToOneIdentifier) {
        this.oneToOneIdentifier = oneToOneIdentifier;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return (this.body == null || this.body.trim().isEmpty()) && this.jsonReply == null;
    }

    @JsonIgnore
    public void setIdentifier(Discussion discussion) throws Exception {
        if (discussion.getGroupId().isPresent()) {
            Group group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get());
            if (group.isV2()) {
                this.setGroupV2Identifier(group.getBytesGroupIdentifier());
            } else {
                this.setGroupOwnerAndUid(group.getBytesGroupIdentifier());
            }
        } else if (discussion.getContactId().isPresent()) {
            Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
            OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
            this.setOneToOneIdentifier(new JsonOneToOneMessageIdentifier(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity()));
        }
    }

    @JsonIgnore
    private void setGroupOwnerAndUid(byte[] bytesGroupOwnerAndUid) throws Exception {
        if (bytesGroupOwnerAndUid.length < 32) {
            throw new Exception();
        }
        byte[] bytesGroupOwner = Arrays.copyOfRange(bytesGroupOwnerAndUid, 0, bytesGroupOwnerAndUid.length - 32);
        byte[] bytesGroupUid = Arrays.copyOfRange(bytesGroupOwnerAndUid, bytesGroupOwnerAndUid.length - 32, bytesGroupOwnerAndUid.length);
        this.setGroupOwner(bytesGroupOwner);
        this.setGroupUid(bytesGroupUid);
    }

    @JsonProperty(value="p")
    @Nullable
    public JsonPoll getJsonPoll() {
        return this.jsonPoll;
    }

    @JsonProperty(value="p")
    public void setJsonPoll(@Nullable JsonPoll jsonPoll) {
        this.jsonPoll = jsonPoll;
    }
}

