/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonLocation {
    @JsonIgnore
    public static final int TYPE_SEND = 1;
    @JsonIgnore
    public static final int TYPE_SHARING = 2;
    @JsonIgnore
    public static final int TYPE_END_SHARING = 3;
    int type;
    long timestamp;
    Long count;
    Long sharingInterval;
    Long sharingExpiration;
    double latitude;
    double longitude;
    Double altitude;
    Float precision;
    String address;
    private static final DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat truncated5 = new DecimalFormat("#0.00000", decimalSymbols);
    private static final DecimalFormat truncated1 = new DecimalFormat("#0.0", decimalSymbols);
    private static final DecimalFormat truncated0 = new DecimalFormat("#0", decimalSymbols);

    public JsonLocation() {
    }

    private JsonLocation(int type, @Nullable Long sharingExpiration, @Nullable Long sharingInterval, @Nullable Long count, double latitude, double longitude, Double altitude, Float precision, long timestamp) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.precision = precision;
        this.timestamp = timestamp;
        this.type = type;
        this.count = count;
        this.sharingExpiration = sharingExpiration;
        this.sharingInterval = sharingInterval;
    }

    @JsonProperty(value="c")
    public Long getCount() {
        return this.count;
    }

    @JsonProperty(value="c")
    public void setCount(Long count) {
        this.count = count;
    }

    @JsonProperty(value="se")
    public Long getSharingExpiration() {
        return this.sharingExpiration;
    }

    @JsonProperty(value="se")
    public void setSharingExpiration(Long sharingExpiration) {
        this.sharingExpiration = sharingExpiration;
    }

    @JsonProperty(value="i")
    public Long getSharingInterval() {
        return this.sharingInterval;
    }

    @JsonProperty(value="i")
    public void setSharingInterval(Long sharingInterval) {
        this.sharingInterval = sharingInterval;
    }

    @JsonProperty(value="t")
    public int getType() {
        return this.type;
    }

    @JsonProperty(value="t")
    public void setType(int type) {
        this.type = type;
    }

    @JsonProperty(value="ts")
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="ts")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="long")
    public double getLongitude() {
        return this.longitude;
    }

    @JsonProperty(value="long")
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="lat")
    public double getLatitude() {
        return this.latitude;
    }

    @JsonProperty(value="lat")
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="alt")
    public Double getAltitude() {
        return this.altitude;
    }

    @JsonProperty(value="alt")
    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    @JsonProperty(value="prec")
    public Float getPrecision() {
        return this.precision;
    }

    @JsonProperty(value="prec")
    public void setPrecision(Float accuracy) {
        this.precision = accuracy;
    }

    @JsonProperty(value="add")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="add")
    public void setAddress(String address) {
        this.address = address;
    }

    @JsonIgnore
    public String getLocationMessageBody() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.address != null && !this.address.isEmpty()) {
            stringBuilder.append(this.address);
            stringBuilder.append("\n\n");
        }
        stringBuilder.append("https://maps.google.com/?q=");
        stringBuilder.append(this.getTruncatedLatitudeString());
        stringBuilder.append("+");
        stringBuilder.append(this.getTruncatedLongitudeString());
        return stringBuilder.toString();
    }

    @JsonIgnore
    public String getTruncatedLatitudeString() {
        return truncated5.format(this.latitude);
    }

    @JsonIgnore
    public String getTruncatedLongitudeString() {
        return truncated5.format(this.longitude);
    }
}

