/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.windows.messenger.database.datatypes.json.JsonOneToOneMessageIdentifier;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonDiscussionRead {
    public long lastReadMessageServerTimestamp;
    public byte[] groupUid;
    public byte[] groupOwner;
    public byte[] groupV2Identifier;
    public JsonOneToOneMessageIdentifier oneToOneIdentifier;

    public static JsonDiscussionRead of(Discussion discussion) throws Exception {
        JsonDiscussionRead jsonDiscussionRead = new JsonDiscussionRead();
        if (discussion.getGroupId().isPresent()) {
            Group group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get());
            if (group.isV2()) {
                jsonDiscussionRead.setGroupV2Identifier(group.getBytesGroupIdentifier());
            } else {
                jsonDiscussionRead.setGroupOwnerAndUid(group.getBytesGroupIdentifier());
            }
        } else if (discussion.getContactId().isPresent()) {
            Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
            OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
            jsonDiscussionRead.oneToOneIdentifier = new JsonOneToOneMessageIdentifier(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
        }
        return jsonDiscussionRead;
    }

    @JsonProperty(value="tim")
    public long getLastReadMessageServerTimestamp() {
        return this.lastReadMessageServerTimestamp;
    }

    @JsonProperty(value="tim")
    public void setLastReadMessageServerTimestamp(long lastReadMessageServerTimestamp) {
        this.lastReadMessageServerTimestamp = lastReadMessageServerTimestamp;
    }

    @JsonProperty(value="guid")
    public byte[] getGroupUid() {
        return this.groupUid;
    }

    @JsonProperty(value="guid")
    public void setGroupUid(byte[] groupUid) {
        this.groupUid = groupUid;
    }

    @JsonProperty(value="go")
    public byte[] getGroupOwner() {
        return this.groupOwner;
    }

    @JsonProperty(value="go")
    public void setGroupOwner(byte[] groupOwner) {
        this.groupOwner = groupOwner;
    }

    @JsonProperty(value="gid2")
    public byte[] getGroupV2Identifier() {
        return this.groupV2Identifier;
    }

    @JsonProperty(value="gid2")
    public void setGroupV2Identifier(byte[] groupV2Identifier) {
        this.groupV2Identifier = groupV2Identifier;
    }

    @JsonProperty(value="o2oi")
    public JsonOneToOneMessageIdentifier getOneToOneIdentifier() {
        return this.oneToOneIdentifier;
    }

    @JsonProperty(value="o2oi")
    public void setOneToOneIdentifier(JsonOneToOneMessageIdentifier oneToOneIdentifier) {
        this.oneToOneIdentifier = oneToOneIdentifier;
    }

    @JsonIgnore
    public void setGroupOwnerAndUid(byte[] bytesGroupOwnerAndUid) throws Exception {
        if (bytesGroupOwnerAndUid.length < 32) {
            throw new Exception();
        }
        byte[] bytesGroupOwner = Arrays.copyOfRange(bytesGroupOwnerAndUid, 0, bytesGroupOwnerAndUid.length - 32);
        byte[] bytesGroupUid = Arrays.copyOfRange(bytesGroupOwnerAndUid, bytesGroupOwnerAndUid.length - 32, bytesGroupOwnerAndUid.length);
        this.setGroupOwner(bytesGroupOwner);
        this.setGroupUid(bytesGroupUid);
    }
}

