/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.pollMessage;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import java.sql.SQLException;
import java.util.List;

public class PollMessageVoteDao
extends OlvidDao<PollMessageVote> {
    public PollMessageVoteDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, PollMessageVote.class);
    }

    public List<PollMessageVote> getVotesForPoll(Id<PollMessage> pollId) throws SQLException {
        ObvQueryBuilder qb = this.queryBuilder();
        qb.where().eq(PollMessageVote.FK_POLL_MESSAGE, pollId);
        return qb.query();
    }

    public List<PollMessageVote> getVotesForMessageBySender(Id<PollMessage> pollId, Id<IdentityRef> senderId) throws SQLException {
        ObvQueryBuilder qb = this.queryBuilder();
        qb.where().eq(PollMessageVote.FK_POLL_MESSAGE, pollId).and().eq(PollMessageVote.FK_IDENTITY_REF, senderId);
        return qb.query();
    }

    public PollMessageVote getVoteByPollMessageBySenderByChoice(Id<PollMessage> pollId, Id<IdentityRef> senderId, Id<PollMessageChoice> choiceId) throws SQLException {
        ObvQueryBuilder qb = this.queryBuilder();
        qb.where().eq(PollMessageVote.FK_POLL_MESSAGE, pollId).and().eq(PollMessageVote.FK_IDENTITY_REF, senderId).and().eq(PollMessageVote.FK_POLL_MESSAGE_CHOICE, choiceId);
        return (PollMessageVote)qb.queryForFirst();
    }
}

