/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.pollMessage;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageChoiceDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageVoteDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.pollMessage.PollMessageVoteGenerated;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class PollMessageDao
extends OlvidDao<PollMessage> {
    private static final UUID UUID_NIL = new UUID(0L, 0L);

    public PollMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, PollMessage.class);
    }

    private PollMessageChoiceDao choiceDao() {
        return DbManager.getInstance().getPollMessageOptionDao();
    }

    private PollMessageVoteDao voteDao() {
        return DbManager.getInstance().getPollMessageVoteDao();
    }

    @Override
    public PollMessage get(Id<PollMessage> id) {
        PollMessage poll = super.get(id);
        try {
            this.populateOptionWithVotes(poll);
        }
        catch (SQLException e) {
            AppLogger.e("Unable to populate poll options", e);
        }
        return poll;
    }

    @Override
    public List<PollMessage> get(Collection<Id<PollMessage>> ids) {
        List<PollMessage> polls = super.get(ids);
        if (polls == null || polls.isEmpty()) {
            return polls;
        }
        try {
            this.populatesOptionsWithVotes(polls);
        }
        catch (SQLException e) {
            AppLogger.e("Unable to populate poll options", e);
        }
        return polls;
    }

    public void populateOptionWithVotes(PollMessage poll) throws SQLException {
        if (poll == null) {
            return;
        }
        List<PollMessageChoice> choices = this.choiceDao().getByPollMessageId((Id<PollMessage>)poll.getItemId());
        List<PollMessageVote> allVotes = this.voteDao().getVotesForPoll((Id<PollMessage>)poll.getItemId());
        poll.choices = choices;
        Map<UUID, Integer> countMap = this.computeVoteCounts(choices, allVotes);
        for (PollMessageChoice choice : choices) {
            int count = countMap.getOrDefault(choice.getExternalIdentifier(), 0);
            choice.setVoteCount(count);
            choice.setSelected(count > 0);
        }
    }

    private void populatesOptionsWithVotes(List<PollMessage> polls) throws SQLException {
        for (PollMessage poll : polls) {
            this.populateOptionWithVotes(poll);
        }
    }

    public PollMessage getAndPopulateOptionVotesWithSender(Id<PollMessage> id, Id<IdentityRef> senderId) throws SQLException {
        PollMessage poll = super.get(id);
        if (poll == null) {
            return null;
        }
        List<PollMessageChoice> choices = this.choiceDao().getByPollMessageId((Id<PollMessage>)poll.getItemId());
        List<PollMessageVote> allVotes = this.voteDao().getVotesForPoll((Id<PollMessage>)poll.getItemId());
        List<PollMessageVote> senderVotes = this.voteDao().getVotesForMessageBySender((Id<PollMessage>)poll.getItemId(), senderId);
        poll.choices = choices;
        Map<UUID, Integer> countMap = this.computeVoteCounts(choices, allVotes);
        boolean senderHasNilVote = senderVotes.stream().anyMatch(this::isNilVote);
        for (PollMessageChoice opt : choices) {
            int count = countMap.getOrDefault(opt.getExternalIdentifier(), 0);
            opt.setVoteCount(count);
            boolean selected = this.isNilChoice(opt) ? senderHasNilVote : (senderHasNilVote && poll.isMultipleChoice() ? false : senderVotes.stream().anyMatch(v -> v.isVoted() && v.getPollMessageChoice().isPresent() && ((Id)v.getPollMessageChoice().get().getItemId()).equals(opt.getItemId())));
            opt.setSelected(selected);
        }
        return poll;
    }

    public PollMessage getFullPollInfo(PollMessage pollMessage, List<PollMessageVote> allVotes, Id<OwnedIdentity> senderId) {
        if (pollMessage == null) {
            return null;
        }
        List<PollMessageChoice> choices = pollMessage.choices;
        IdentityRef ref = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(senderId);
        List<PollMessageVote> senderVotes = allVotes.stream().filter(pollMessageVote -> pollMessageVote.getIdentityRefId().get().equals(ref.getItemId())).toList();
        pollMessage.choices = choices;
        Map<UUID, Integer> countMap = this.computeVoteCounts(choices, allVotes);
        boolean senderHasNilVote = senderVotes.stream().anyMatch(this::isNilVote);
        for (PollMessageChoice opt : choices) {
            int count = countMap.getOrDefault(opt.getExternalIdentifier(), 0);
            ViewControllerHelper.smartUIUpdate(() -> opt.setVoteCount(count));
            boolean selected = this.isNilChoice(opt) ? senderHasNilVote : (senderHasNilVote && pollMessage.isMultipleChoice() ? false : senderVotes.stream().anyMatch(v -> v.isVoted() && v.getPollMessageChoice().isPresent() && ((Id)v.getPollMessageChoice().get().getItemId()).equals(opt.getItemId())));
            ViewControllerHelper.smartUIUpdate(() -> opt.setSelected(selected));
        }
        return pollMessage;
    }

    private Map<UUID, Integer> computeVoteCounts(List<PollMessageChoice> choices, List<PollMessageVote> allVotes) {
        HashMap<UUID, Integer> countMap = new HashMap<UUID, Integer>();
        for (PollMessageChoice choice : choices) {
            countMap.put(choice.getExternalIdentifier(), 0);
        }
        Map<Optional, List<PollMessageVote>> votesBySender = allVotes.stream().collect(Collectors.groupingBy(PollMessageVoteGenerated::getIdentityRefId));
        for (List<PollMessageVote> senderVotes : votesBySender.values()) {
            if (senderVotes == null || senderVotes.isEmpty()) continue;
            boolean hasNilVote = senderVotes.stream().anyMatch(this::isNilVote);
            if (hasNilVote) {
                PollMessageChoice nilChoice = choices.stream().filter(this::isNilChoice).findFirst().orElse(null);
                if (nilChoice == null) continue;
                UUID nilId = nilChoice.getExternalIdentifier();
                countMap.computeIfPresent(nilId, (k, v) -> v + 1);
                continue;
            }
            senderVotes.stream().filter(PollMessageVoteGenerated::isVoted).forEach(v -> v.getPollMessageChoice().ifPresent(choice -> {
                UUID choiceId = choice.getExternalIdentifier();
                countMap.computeIfPresent(choiceId, (k, val) -> val + 1);
            }));
        }
        return countMap;
    }

    private boolean isNilChoice(PollMessageChoice choice) {
        return UUID_NIL.equals(choice.getExternalIdentifier());
    }

    private boolean isNilVote(PollMessageVote vote) {
        return vote.isVoted() && vote.getPollMessageChoice().isPresent() && this.isNilChoice(vote.getPollMessageChoice().get());
    }
}

