/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.message.AbstractMessageDao;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public class SystemMessageDao
extends AbstractMessageDao<SystemMessage, SystemMessageGenerated.Interface> {
    public SystemMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, SystemMessage.class);
    }

    public void deleteAllDiscussionNewPublishedDetailsMessages(Discussion discussion) {
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("deleteAllDiscussionNewPublishedDetailsMessages: invalid params");
        }
        try {
            deleteBuilder.where().eq(SystemMessage.FK_DISCUSSION, discussion).and().eq(SystemMessage.CATEGORY, SystemMessageGenerated.Category.NEW_PUBLISHED_DETAILS);
            deleteBuilder.delete();
        }
        catch (SQLException throwables) {
            AppLogger.e("deleteAllDiscussionNewPublishedDetailsMessages: SQLException", throwables);
        }
    }

    @Override
    protected SortableItemId getItemId(Id<SystemMessage> systemMessageId, double sortIndex) {
        return SortableItemId.ofSystem(systemMessageId, sortIndex);
    }

    @Override
    protected List<Column<? super SystemMessage>> getMapRowColumns() {
        return SystemMessage.MAP_ROW_COLUMNS;
    }

    @Override
    protected SystemMessageGenerated.Interface make(SystemMessage systemMessage) {
        return systemMessage;
    }
}

