/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public abstract class ReceivedMessageDao<Message extends ReceivedMessageGenerated<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, Interface extends AbstractUserMessageGenerated.Interface<Message>>
extends AbstractUserMessageDao<Message, EphemeralInfo, Interface> {
    public ReceivedMessageDao(ConnectionSource singleConnectionSource, Class<Message> clazz, String tableName) throws SQLException {
        super(singleConnectionSource, clazz, tableName);
    }

    public void updateBodyAndMarkAsEdited(Id<Message> genId, Optional<String> newBody) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(ReceivedMessageGenerated.GEN_ID, genId);
            updateBuilder.updateColumnValue(ReceivedMessageGenerated.EDITION_STATUS, AbstractUserMessageGenerated.EditionStatus.UNSEEN);
            updateBuilder.updateColumnValue(ReceivedMessageGenerated.BODY, newBody.orElse(null));
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to updateBodyAndMarkAsEdited", throwables);
        }
    }

    public long getCountForEngineIdentifier(byte[] bytesToIdentity, byte[] identifier) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        ObvQueryBuilder discussionQb = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder identityQb = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        this.checkThread();
        if (bytesToIdentity == null || identifier == null) {
            AppLogger.e("Invalid parameters: getCountForEngineIdentifier");
            return 0L;
        }
        try {
            identityQb.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesToIdentity);
            discussionQb.join(Discussion.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, identityQb);
            messageQB.where().eq(ReceivedMessageGenerated.ENGINE_MESSAGE_IDENTIFIER, identifier);
            messageQB.join(ReceivedMessageGenerated.FK_DISCUSSION, Discussion.GEN_ID, discussionQb);
            return messageQB.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("getCountForEngineIdentifier: Unable to query", throwables);
            return -1L;
        }
    }

    public Message getMessage(Id<EphemeralInfo> ephemeralInfoId) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        try {
            messageQB.where().eq(this.getEphemeralInfoColumn(), ephemeralInfoId);
            return (Message)((ReceivedMessageGenerated)messageQB.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("InboundMessageDao.getMessage: unable to query", e);
            return null;
        }
    }

    public void updateMissedMessageCount(Id<Message> messageId, long count) {
        ObvUpdateBuilder<ReceivedMessageGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(ReceivedMessageGenerated.GEN_ID, messageId);
            updateBuilder.updateColumnValue(ReceivedMessageGenerated.MISSED_MESSAGE_COUNT, count);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateMissedMessageCount: Unable to update", throwables);
        }
    }
}

