/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class OwnedMessageDao
extends ReceivedMessageDao<OwnedMessage, OwnedMessageEphemeralInfo, OwnedMessageGenerated.Interface> {
    public OwnedMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OwnedMessage.class, "owned_message_table");
    }

    @Override
    protected Column.ForeignColumn<OwnedMessage, OwnedMessageEphemeralInfo> getEphemeralInfoColumn() {
        return OwnedMessage.FK_OWNED_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected AbstractMessageEphemeralInfoDao<OwnedMessage, OwnedMessageEphemeralInfo> getEphemeralInfoDao() {
        return DbManager.getInstance().getOwnedMessageEphemeralInfoDao();
    }

    public boolean updateStatus(Id<OwnedMessage> genId, OwnedMessageGenerated.Status status) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(OwnedMessage.STATUS, status);
            updateBuilder.where().eq(OwnedMessage.GEN_ID, genId);
            return updateBuilder.update() == 1;
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to update message status", throwables);
            return false;
        }
    }

    public void updateContentBody(OwnedMessage message, String contentBody) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(OwnedMessage.BODY, contentBody);
            updateBuilder.where().eq(OwnedMessage.GEN_ID, message.getItemId());
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to update message content body", throwables);
        }
    }

    @Override
    public Optional<OwnedMessageEphemeralInfo> getEphemeralInfo(OwnedMessage message) {
        if (message.getOwnedMessageEphemeralInfoId().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(DbManager.getInstance().getOwnedMessageEphemeralInfoDao().get(message.getOwnedMessageEphemeralInfoId().get()));
    }

    public byte[] getSenderIdentifier(OwnedMessage message) {
        this.checkThread();
        ObvQueryBuilder discussionQb = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder ownedIdentityQb = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        try {
            discussionQb.where().eq(Discussion.GEN_ID, message.getDiscussionId());
            ownedIdentityQb.join(OwnedIdentity.GEN_ID, Discussion.FK_OWNED_IDENTITY, discussionQb);
            return ((OwnedIdentity)ownedIdentityQb.queryForFirst()).getBytesOwnedIdentity();
        }
        catch (SQLException throwables) {
            AppLogger.e("getSenderIdentifier: Unable to query", throwables);
            return null;
        }
    }

    @Override
    public Optional<Double> getNextSortIndex(double minSortIndex, Discussion discussion) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getNextSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(OwnedMessage.FK_DISCUSSION, discussion).and().gt(OwnedMessage.SORT_INDEX, minSortIndex);
            messageQB.selectColumns(OwnedMessage.SORT_INDEX);
            messageQB.orderBy(OwnedMessage.SORT_INDEX, true);
            OwnedMessage message = (OwnedMessage)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getNextSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Double> getPreviousSortIndex(double maxSortIndex, Discussion discussion) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getPreviousSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(OwnedMessage.FK_DISCUSSION, discussion).and().lt(OwnedMessage.SORT_INDEX, maxSortIndex);
            messageQB.selectColumns(OwnedMessage.SORT_INDEX);
            messageQB.orderBy(OwnedMessage.SORT_INDEX, false);
            OwnedMessage message = (OwnedMessage)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getPreviousSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    public Optional<OwnedMessage> get(Id<Discussion> discussionId, JsonMessageReference reference) {
        return super.get(discussionId, reference.getSenderSequenceNumber(), reference.getSenderThreadIdentifier(), Optional.empty(), Optional.empty());
    }

    @Override
    public OwnedMessage getMessage(Id<OwnedMessageEphemeralInfo> ephemeralInfoId) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        try {
            messageQB.where().eq(OwnedMessage.FK_OWNED_MESSAGE_EPHEMERAL_INFO, ephemeralInfoId);
            return (OwnedMessage)messageQB.queryForFirst();
        }
        catch (SQLException e) {
            AppLogger.e("OwnedMessageDao.getMessage: unable to query", e);
            return null;
        }
    }

    @Override
    protected SortableItemId getItemId(Id<OwnedMessage> ownedMessageId, double sortIndex) {
        return SortableItemId.ofOwned(ownedMessageId, sortIndex);
    }

    @Override
    protected List<Column<? super OwnedMessage>> getMapRowColumns() {
        return OwnedMessage.MAP_ROW_COLUMNS;
    }

    @Override
    protected OwnedMessageGenerated.Interface make(OwnedMessage ownedMessage) {
        return ownedMessage;
    }

    @Override
    protected SortableItemId ofSpecificItemIdWithSortIndex(long id, double sortIndex) {
        return SortableItemId.ofOwned(new Id<OwnedMessage>(OwnedMessage.class, id), sortIndex);
    }
}

