/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class MessageRefDao
extends OlvidDao<MessageRef> {
    public MessageRefDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, MessageRef.class);
    }

    private Optional<MessageRef> get(InboundMessage inboundMessage) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRef.FK_INBOUND_MESSAGE, inboundMessage);
            return Optional.ofNullable((MessageRef)queryBuilder.queryForFirst()).or(() -> this.get(inboundMessage.getDiscussionId(), inboundMessage.getSenderSequenceNumber(), inboundMessage.getSenderThreadIdentifier(), DbManager.getInstance().getInboundMessageDao().getSenderIdentifier(inboundMessage)));
        }
        catch (SQLException e) {
            AppLogger.e("get(InboundMessage inboundMessage)", e);
            return Optional.empty();
        }
    }

    private Optional<MessageRef> get(OutboundMessage outboundMessage) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRef.FK_OUTBOUND_MESSAGE, outboundMessage);
            return Optional.ofNullable((MessageRef)queryBuilder.queryForFirst()).or(() -> this.get(outboundMessage.getDiscussionId(), outboundMessage.getSenderSequenceNumber(), outboundMessage.getSenderThreadIdentifier(), DbManager.getInstance().getOutboundMessageDao().getSenderIdentifier(outboundMessage)));
        }
        catch (SQLException e) {
            AppLogger.e("get(OutboundMessage outboundMessage)", e);
            return Optional.empty();
        }
    }

    private Optional<MessageRef> get(OwnedMessage ownedMessage) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRef.FK_OWNED_MESSAGE, ownedMessage);
            return Optional.ofNullable((MessageRef)queryBuilder.queryForFirst()).or(() -> this.get(ownedMessage.getDiscussionId(), ownedMessage.getSenderSequenceNumber(), ownedMessage.getSenderThreadIdentifier(), DbManager.getInstance().getOwnedMessageDao().getSenderIdentifier(ownedMessage)));
        }
        catch (SQLException e) {
            AppLogger.e("get(OwnedMessage ownedMessage)", e);
            return Optional.empty();
        }
    }

    public Optional<MessageRef> get(Id<Discussion> discussionId, JsonMessageReference jsonMessageReference) {
        return this.get(discussionId, jsonMessageReference.getSenderSequenceNumber(), jsonMessageReference.getSenderThreadIdentifier(), jsonMessageReference.getSenderIdentifier());
    }

    public Optional<MessageRef> get(Id<Discussion> discussionId, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRef.FK_DISCUSSION, discussionId).and().eq(MessageRef.SENDER_SEQUENCE_NUMBER, senderSequenceNumber).and().eq(MessageRef.SENDER_THREAD_IDENTIFIER, senderThreadIdentifier).and().eq(MessageRef.SENDER_IDENTIFIER, senderIdentifier);
            return Optional.ofNullable((MessageRef)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("get(Discussion, JsonMessageReference)", e);
            return Optional.empty();
        }
    }

    public List<MessageRef> getAll(Id<Discussion> discussionId) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRef.FK_DISCUSSION, discussionId);
            return queryBuilder.query();
        }
        catch (SQLException e) {
            AppLogger.e("getAll(Id<Discussion>", e);
            return List.of();
        }
    }

    @Override
    public Optional<MessageRef> get(AbstractUserMessageGenerated<?> message) {
        if (message instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)message;
            return this.get(inboundMessage);
        }
        if (message instanceof OutboundMessage) {
            OutboundMessage outboundMessage = (OutboundMessage)message;
            return this.get(outboundMessage);
        }
        if (message instanceof OwnedMessage) {
            OwnedMessage ownedMessage = (OwnedMessage)message;
            return this.get(ownedMessage);
        }
        return Optional.empty();
    }

    public void updateMessageRef(ReceivedMessageGenerated<?> message) {
        Optional<MessageRef> messageRefOpt = this.get(message);
        if (messageRefOpt.isEmpty()) {
            AppLogger.e("Try to update a MessageRef that does not exists");
            return;
        }
        MessageRef messageRef = messageRefOpt.get();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(MessageRef.GEN_ID, messageRef.getItemId());
            if (message instanceof InboundMessage) {
                InboundMessage inboundMessage = (InboundMessage)message;
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(MessageRef.FK_INBOUND_MESSAGE, inboundMessage.getItemId());
            } else if (message instanceof OwnedMessage) {
                OwnedMessage ownedMessage = (OwnedMessage)message;
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(MessageRef.FK_OWNED_MESSAGE, ownedMessage.getItemId());
            } else {
                AppLogger.e("Found an unexpected message type");
                return;
            }
            updateBuilder.updateColumnValue(MessageRef.MESSAGE_HAS_BEEN_RECEIVED, true);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("updateMessageRef(AbstractUserMessage)", e);
        }
    }

    public synchronized MessageRef getOrCreate(Discussion discussion, JsonMessageReference jsonMessageReference) {
        MessageRef ref;
        Optional ownedMessage;
        Optional<InboundMessage> inboundMessage;
        Optional<MessageRef> refOpt = this.get((Id<Discussion>)discussion.getItemId(), jsonMessageReference);
        if (refOpt.isPresent()) {
            return refOpt.get();
        }
        long senderSequenceNumber = jsonMessageReference.getSenderSequenceNumber();
        UUID senderThreadIdentifier = jsonMessageReference.getSenderThreadIdentifier();
        Optional outboundMessage = DbManager.getInstance().getOutboundMessageDao().get((Id<Discussion>)discussion.getItemId(), senderSequenceNumber, senderThreadIdentifier, Optional.empty(), Optional.empty());
        long count = Stream.of(outboundMessage, inboundMessage = DbManager.getInstance().getInboundMessageDao().get((Id<Discussion>)discussion.getItemId(), jsonMessageReference), ownedMessage = DbManager.getInstance().getOwnedMessageDao().get((Id<Discussion>)discussion.getItemId(), senderSequenceNumber, senderThreadIdentifier, Optional.empty(), Optional.empty())).filter(Optional::isPresent).count();
        if (count == 0L) {
            ref = MessageRef.of(discussion, jsonMessageReference);
        } else if (count == 1L) {
            if (outboundMessage.isPresent()) {
                ref = MessageRef.of(discussion, jsonMessageReference, (OutboundMessage)outboundMessage.get());
            } else if (inboundMessage.isPresent()) {
                ref = MessageRef.of(discussion, jsonMessageReference, inboundMessage.get());
            } else {
                assert (ownedMessage.isPresent());
                ref = MessageRef.of(discussion, jsonMessageReference, (OwnedMessage)ownedMessage.get());
            }
        } else {
            AppLogger.e("ISSUE, please report");
            ref = MessageRef.of(discussion, jsonMessageReference);
        }
        this.insert(ref);
        return ref;
    }

    public synchronized MessageRef getOrCreate(AbstractUserMessageGenerated<?> message) {
        Optional<MessageRef> referenceOpt = this.get(message);
        if (referenceOpt.isPresent()) {
            return referenceOpt.get();
        }
        MessageRef messageRef = MessageRef.of(message);
        messageRef = this.createIfNotExists(messageRef);
        Objects.requireNonNull(messageRef);
        return messageRef;
    }

    private <T> void addNotInClause(TableReference<T, MessageRef> ref, ObvWhere<MessageRef> where) throws SQLException {
        OlvidAbstractDao<T> dao = DbManager.getInstance().getDao(ref.tableClass());
        ObvQueryBuilder<T> queryBuilder = dao.queryBuilder();
        Column.ForeignColumn<T, MessageRef> column = ref.column();
        queryBuilder.selectColumns(column);
        if (column.canBeNull) {
            queryBuilder.where().isNotNull(column);
        }
        where.notIn((Column.IdColumn<MessageRef>)MessageRef.GEN_ID, queryBuilder);
    }

    public void cleanUnreferencedMessageRef() {
        try {
            MessageRefDao messageRefDao = DbManager.getInstance().getMessageRefDao();
            ObvDeleteBuilder deleteBuilder = messageRefDao.deleteBuilder();
            ObvWhere<MessageRef> where = deleteBuilder.where();
            for (TableReference ref : MessageRef.references) {
                this.addNotInClause(ref, where);
            }
            where.and(MessageRef.references.size());
            int count = deleteBuilder.delete();
            AppLogger.i(String.format("Clean %d MessageRef", count));
        }
        catch (SQLException e) {
            AppLogger.e("Unable to clean unreferenced MessageRef", e);
        }
    }
}

