/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.AbstractMessageDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractUserMessageDao<Message extends AbstractUserMessageGenerated<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, Interface extends AbstractUserMessageGenerated.Interface<Message>>
extends AbstractMessageDao<Message, Interface> {
    protected final String tableName;

    protected AbstractUserMessageDao(ConnectionSource singleConnectionSource, Class<Message> messageClass, String tableName) throws SQLException {
        super(singleConnectionSource, messageClass);
        this.tableName = tableName;
    }

    protected abstract Column.ForeignColumn<Message, EphemeralInfo> getEphemeralInfoColumn();

    protected abstract AbstractMessageEphemeralInfoDao<Message, EphemeralInfo> getEphemeralInfoDao();

    private Column.ForeignColumn<AbstractUserMessageGenerated<?>, PollMessage> getPollColumn() {
        return AbstractUserMessageGenerated.FK_POLL_MESSAGE;
    }

    private PollMessageDao getPollMessageDao() {
        return DbManager.getInstance().getPollMessageDao();
    }

    public List<Message> getAllWipeOnRead() {
        this.checkThread();
        ObvQueryBuilder messageQB = this.queryBuilder();
        try {
            messageQB.where().eq(AbstractUserMessageGenerated.WIPE_STATUS, AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ);
            return messageQB.query();
        }
        catch (SQLException e) {
            AppLogger.e("getAllWipeRead: Unable to update", e);
            return null;
        }
    }

    public void updateWipeStatusAndClearContent(Id<Message> genId, AbstractUserMessageGenerated.WipeStatus wipeStatus) {
        ObvUpdateBuilder<AbstractUserMessageGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.BODY, null);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(AbstractUserMessageGenerated.FK_REPLY_TO, (MessageRef)null);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(AbstractUserMessageGenerated.FK_LOCATION, (Location)null);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.EDITION_STATUS, AbstractUserMessageGenerated.EditionStatus.NONE);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.FORWARDED, false);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.WIPE_STATUS, wipeStatus);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.TOTAL_ATTACHMENT_COUNT, 0);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.IMAGE_COUNT, 0);
            updateBuilder.where().eq(AbstractUserMessageGenerated.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to updateWipeStatusAndClearContent", throwables);
        }
    }

    public void updateWipe(Id<Message> genId, AbstractUserMessageGenerated.WipeStatus wipeStatus) {
        ObvUpdateBuilder<AbstractUserMessageGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.WIPE_STATUS, wipeStatus);
            updateBuilder.where().eq(AbstractUserMessageGenerated.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to updateWipe", throwables);
        }
    }

    protected abstract Optional<EphemeralInfo> getEphemeralInfo(Message var1);

    public abstract Optional<Message> get(Id<Discussion> var1, JsonMessageReference var2);

    protected Optional<Message> get(Id<Discussion> discussionId, long senderSequenceNumber, UUID senderThreadIdentifier, Optional<Column.ForeignColumn<Message, ContactRef>> contactRefColumn, Optional<ObvQueryBuilder<ContactRef>> contactRefQueryBuilder) {
        this.checkThread();
        ObvQueryBuilder<Message> queryBuilder = this.queryBuilder();
        if (discussionId == null) {
            AppLogger.e("AbstractUserMessageDao.get(Discussion, JsonMessageReference): invalid params");
            return Optional.empty();
        }
        if (senderThreadIdentifier == null) {
            AppLogger.e("AbstractUserMessageDao.get(Discussion, JsonMessageReference): invalid params");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(AbstractUserMessageGenerated.FK_DISCUSSION, discussionId).and().eq(AbstractUserMessageGenerated.SENDER_SEQUENCE_NUMBER, senderSequenceNumber).and().eq(AbstractUserMessageGenerated.SENDER_THREAD_IDENTIFIER, senderThreadIdentifier);
            if (contactRefQueryBuilder.isPresent() && contactRefColumn.isPresent()) {
                queryBuilder.join(contactRefColumn.get(), ContactRef.GEN_ID, contactRefQueryBuilder.get());
            }
            queryBuilder.leftJoin(this.getPollMessageDao().queryBuilder());
            return Optional.ofNullable((AbstractUserMessageGenerated)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("InboundMessageDao.get(Discussion, JsonMessageReference): Unable to update", e);
            return Optional.empty();
        }
    }

    public void updateAttachmentCount(Message message, int totalAttachmentCount, int imageCount) {
        ObvUpdateBuilder<AbstractUserMessageGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.TOTAL_ATTACHMENT_COUNT, totalAttachmentCount);
            updateBuilder.updateColumnValue(AbstractUserMessageGenerated.IMAGE_COUNT, imageCount);
            updateBuilder.where().eq(AbstractUserMessageGenerated.GEN_ID, ((AbstractTableGenerated)message).getItemId());
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to updateAttachmentCount", throwables);
        }
    }

    public final boolean updateEphemeraInfo(Id<Message> messageId, EphemeralInfo ephemeralInfo) {
        ObvUpdateBuilder<Message> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractUserMessageGenerated.GEN_ID, messageId);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(this.getEphemeralInfoColumn(), ((AbstractTableGenerated)ephemeralInfo).getItemId());
            if (updateBuilder.update() != 1) {
                return false;
            }
            AbstractMessageEphemeralInfoDao<Message, EphemeralInfo> ephemeralInfoDao = this.getEphemeralInfoDao();
            ephemeralInfoDao.update(ephemeralInfo);
            return true;
        }
        catch (SQLException throwables) {
            AppLogger.e("updateEphemeraInfo: Unable to update", throwables);
            return false;
        }
    }

    public void updateLinkPreviewInfo(ObvUpdateBuilder<Message> updateBuilder, Optional<LinkPreviewInfo> linkPreviewInfo) {
        this.checkThread();
        try {
            if (linkPreviewInfo.isPresent()) {
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_KIND, linkPreviewInfo.get().getLinkPreviewKind());
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_DESCRIPTION, linkPreviewInfo.get().description().orElse(null));
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_IMAGE_WIDTH, linkPreviewInfo.get().imageWidth().orElse(null));
            } else {
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_KIND, AbstractUserMessageGenerated.LinkPreviewKind.NONE);
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_DESCRIPTION, null);
                updateBuilder.updateColumnValue(AbstractUserMessageGenerated.LINK_PREVIEW_IMAGE_WIDTH, null);
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateLinkPreviewInfo: Unable to update", e);
        }
    }

    public void updateLinkPreviewInfo(Id<Message> genId, Optional<LinkPreviewInfo> linkPreviewInfo) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractUserMessageGenerated.GEN_ID, genId);
            this.updateLinkPreviewInfo(updateBuilder, linkPreviewInfo);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("updateLinkPreviewInfo: Unable to update", e);
        }
    }

    protected abstract SortableItemId ofSpecificItemIdWithSortIndex(long var1, double var3);

    protected SortableItemId mapFtsRawQuery(DatabaseResults result, String prefix) {
        try {
            long val1 = AbstractTableGenerated.getLong(result, AbstractTableGenerated.GEN_ID, prefix);
            double val2 = AbstractTableGenerated.getDouble(result, AbstractMessageGenerated.SORT_INDEX, prefix);
            return this.ofSpecificItemIdWithSortIndex(val1, val2);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public List<SortableItemId> ftsInDiscussion(Id<Discussion> discussionId, List<String> tokenizedStrings) {
        block10: {
            List list;
            block9: {
                this.checkThread();
                String preformattedString = "SELECT %s.`%s` AS a_%s, %s.`%s` AS a_%s from %s JOIN %s ON %s.`%s` = %s.`%s` WHERE %s.`%s` = %s AND  %s.`%s` MATCH '%s' ORDER BY %s.`%s`";
                String query = String.format("SELECT %s.`%s` AS a_%s, %s.`%s` AS a_%s from %s JOIN %s ON %s.`%s` = %s.`%s` WHERE %s.`%s` = %s AND  %s.`%s` MATCH '%s' ORDER BY %s.`%s`", this.tableName, AbstractUserMessageGenerated.GEN_ID, AbstractUserMessageGenerated.GEN_ID, this.tableName, AbstractUserMessageGenerated.SORT_INDEX, AbstractUserMessageGenerated.SORT_INDEX, this.tableName, this.tableName + "_fts", this.tableName, AbstractUserMessageGenerated.GEN_ID, this.tableName + "_fts", "rowid", this.tableName, AbstractUserMessageGenerated.FK_DISCUSSION, discussionId.getId(), this.tableName + "_fts", AbstractUserMessageGenerated.BODY, AbstractUserMessageDao.tokenize(tokenizedStrings), this.tableName, AbstractUserMessageGenerated.SORT_INDEX);
                GenericRawResults results = this.queryRaw(query, databaseResults -> this.mapFtsRawQuery(databaseResults, "a_"));
                try {
                    list = results.getResults();
                    if (results == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        AppLogger.e("ftsInDiscussion: couldn't execute raw query", e);
                        break block10;
                    }
                    catch (Exception e) {
                        AppLogger.e("ftsInDiscussion: General error", e);
                    }
                }
                results.close();
            }
            return list;
        }
        return List.of();
    }

    protected static String tokenize(List<String> initialTokens) {
        StringBuilder toRet = new StringBuilder();
        for (String token : initialTokens) {
            toRet.append(String.format("\"%s\"* ", token));
        }
        return toRet.toString();
    }
}

