/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMessageDao<Message extends AbstractMessageGenerated<Message>, Interface>
extends OlvidDao<Message> {
    protected AbstractMessageDao(ConnectionSource singleConnectionSource, Class<Message> messageClass) throws SQLException {
        super(singleConnectionSource, messageClass);
    }

    public List<Message> getAllMessagesForDiscussion(Discussion discussion) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getAllMessagesForDiscussion");
            return null;
        }
        try {
            queryBuilder.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion);
            return queryBuilder.query();
        }
        catch (SQLException e) {
            AppLogger.e("getAllMessagesForDiscussion: Unable to query: ", e);
            return null;
        }
    }

    public Optional<Double> getNextSortIndex(double minSortIndex, Discussion discussion) {
        ObvQueryBuilder<AbstractMessageGenerated<?>> messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getNextSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion).and().gt(AbstractMessageGenerated.SORT_INDEX, minSortIndex);
            messageQB.selectColumns(AbstractMessageGenerated.SORT_INDEX);
            messageQB.orderBy(AbstractMessageGenerated.SORT_INDEX, true);
            AbstractMessageGenerated message = (AbstractMessageGenerated)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getNextSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public Optional<Double> getPreviousSortIndex(double maxSortIndex, Discussion discussion) {
        ObvQueryBuilder<AbstractMessageGenerated<?>> messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getPreviousSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion).and().lt(AbstractMessageGenerated.SORT_INDEX, maxSortIndex);
            messageQB.selectColumns(AbstractMessageGenerated.SORT_INDEX);
            messageQB.orderBy(AbstractMessageGenerated.SORT_INDEX, false);
            AbstractMessageGenerated message = (AbstractMessageGenerated)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getPreviousSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public Optional<Double> getDiscussionMaxSortIndex(Discussion discussion) {
        ObvQueryBuilder<AbstractMessageGenerated<?>> messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getDiscussionMaxSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion);
            messageQB.orderBy(AbstractMessageGenerated.SORT_INDEX, false);
            messageQB.selectColumns(AbstractMessageGenerated.SORT_INDEX);
            AbstractMessageGenerated message = (AbstractMessageGenerated)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionMaxSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public Optional<Message> getLastMessageForDiscussion(Discussion discussion) {
        ObvQueryBuilder<AbstractMessageGenerated<?>> queryBuilder = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getLastMessageForDiscussion");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion);
            queryBuilder.orderBy(AbstractMessageGenerated.SORT_INDEX, false);
            return Optional.ofNullable((AbstractMessageGenerated)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getLastMessageForDiscussion: Unable to query: ", e);
            return Optional.empty();
        }
    }

    public Optional<Long> countMessagesInDiscussion(Discussion discussion) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: countMessagesInDiscussion");
            return Optional.empty();
        }
        try {
            return Optional.of(messageQB.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion).countOf());
        }
        catch (SQLException throwables) {
            AppLogger.e("countMessagesInDiscussion: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public final List<SortableItemId> getSortedMessagesItemIdByDiscussion(Id<Discussion> discussionId) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            ObvWhere<AbstractMessageGenerated<?>> where = queryBuilder.where();
            where.eq(AbstractMessageGenerated.FK_DISCUSSION, discussionId);
            return this.computeSortedMessagesItemIdByDiscussion(queryBuilder);
        }
        catch (SQLException e) {
            return List.of();
        }
    }

    protected abstract SortableItemId getItemId(Id<Message> var1, double var2);

    protected List<SortableItemId> computeSortedMessagesItemIdByDiscussion(ObvQueryBuilder<Message> queryBuilder) throws SQLException {
        queryBuilder.selectColumns(AbstractMessageGenerated.GEN_ID, AbstractMessageGenerated.SORT_INDEX);
        queryBuilder.orderBy(AbstractMessageGenerated.SORT_INDEX, true);
        List<Message> messages = queryBuilder.query();
        ArrayList<SortableItemId> ids = new ArrayList<SortableItemId>(messages.size());
        for (AbstractMessageGenerated message : messages) {
            ids.add(this.getItemId((Id<Message>)message.getItemId(), message.getSortIndex()));
        }
        return ids;
    }

    protected abstract List<Column<? super Message>> getMapRowColumns();

    protected abstract Interface make(Message var1);

    public List<Interface> getAll(Id<Discussion> discussionId, double startSortIndex, double endSortIndex) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussionId).and().ge(AbstractMessageGenerated.SORT_INDEX, startSortIndex).and().le(AbstractMessageGenerated.SORT_INDEX, endSortIndex);
            queryBuilder.selectColumns(this.getMapRowColumns());
            return queryBuilder.query().stream().map(this::make).toList();
        }
        catch (SQLException e) {
            AppLogger.e("get: Unable to query: ", e);
            return null;
        }
    }
}

