/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.interfaces;

import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import java.sql.SQLException;

public interface DaoWithForeignMessage<Message extends AbstractUserMessageGenerated<Message>> {
    public ObvQueryBuilder<Message> messageQueryBuilder(Id<Discussion> var1, double var2, boolean var4, double var5, boolean var7) throws SQLException;

    public static interface Owned
    extends DaoWithForeignMessage<OwnedMessage> {
        @Override
        default public ObvQueryBuilder<OwnedMessage> messageQueryBuilder(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
            ObvQueryBuilder<OwnedMessage> queryBuilder = DbManager.getInstance().getOwnedMessageDao().queryBuilder();
            ObvWhere where = queryBuilder.where();
            where.eq(OwnedMessage.FK_DISCUSSION, discussionID);
            if (excludeMin) {
                where.and().gt(OwnedMessage.SORT_INDEX, sortIndexMin);
            } else {
                where.and().ge(OwnedMessage.SORT_INDEX, sortIndexMin);
            }
            if (excludeMax) {
                where.and().lt(OwnedMessage.SORT_INDEX, sortIndexMax);
            } else {
                where.and().le(OwnedMessage.SORT_INDEX, sortIndexMax);
            }
            return queryBuilder;
        }
    }

    public static interface Outbound
    extends DaoWithForeignMessage<OutboundMessage> {
        @Override
        default public ObvQueryBuilder<OutboundMessage> messageQueryBuilder(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
            ObvQueryBuilder<OutboundMessage> queryBuilder = DbManager.getInstance().getOutboundMessageDao().queryBuilder();
            ObvWhere where = queryBuilder.where();
            where.eq(OutboundMessage.FK_DISCUSSION, discussionID).and().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT);
            if (excludeMin) {
                where.and().gt(OutboundMessage.SORT_INDEX, sortIndexMin);
            } else {
                where.and().ge(OutboundMessage.SORT_INDEX, sortIndexMin);
            }
            if (excludeMax) {
                where.and().lt(OutboundMessage.SORT_INDEX, sortIndexMax);
            } else {
                where.and().le(OutboundMessage.SORT_INDEX, sortIndexMax);
            }
            return queryBuilder;
        }
    }

    public static interface Inbound
    extends DaoWithForeignMessage<InboundMessage> {
        @Override
        default public ObvQueryBuilder<InboundMessage> messageQueryBuilder(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
            ObvQueryBuilder<InboundMessage> queryBuilder = DbManager.getInstance().getInboundMessageDao().queryBuilder();
            ObvWhere where = queryBuilder.where();
            where.eq(InboundMessage.FK_DISCUSSION, discussionID);
            if (excludeMin) {
                where.and().gt(InboundMessage.SORT_INDEX, sortIndexMin);
            } else {
                where.and().ge(InboundMessage.SORT_INDEX, sortIndexMin);
            }
            if (excludeMax) {
                where.and().lt(InboundMessage.SORT_INDEX, sortIndexMax);
            } else {
                where.and().le(InboundMessage.SORT_INDEX, sortIndexMax);
            }
            return queryBuilder;
        }
    }
}

