/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.ephemerality;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public class OutboundMessageEphemeralInfoDao
extends AbstractMessageEphemeralInfoDao<OutboundMessage, OutboundMessageEphemeralInfo> {
    public OutboundMessageEphemeralInfoDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OutboundMessageEphemeralInfo.class, "outbound_message_ephemeral_info_table");
    }

    @Override
    protected ObvQueryBuilder<OutboundMessage> messageQueryBuilder(Id<Discussion> discussionId) throws SQLException {
        ObvQueryBuilder<OutboundMessage> messageQB = DbManager.getInstance().getOutboundMessageDao().queryBuilder();
        messageQB.where().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT).and().eq(OutboundMessage.FK_DISCUSSION, discussionId);
        return messageQB;
    }

    @Override
    protected Column.ForeignColumn<OutboundMessage, OutboundMessageEphemeralInfo> getEphemeralInfoColumn() {
        return OutboundMessage.FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected Optional<Id<OutboundMessageEphemeralInfo>> getInfoId(OutboundMessage outboundMessage) {
        return outboundMessage.getOutboundMessageEphemeralInfoId();
    }

    @Override
    protected void clearVisibilityExpirationInfoAux(ObvUpdateBuilder<OutboundMessageEphemeralInfo> updateBuilder) throws SQLException {
        updateBuilder.updateColumnValue(OutboundMessageEphemeralInfo.RETAIN_WIPED_MESSAGE, false);
    }

    public void updateVisibilityExpiration(Id<OutboundMessageEphemeralInfo> id, long timestamp, boolean retainWipedMessage) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OutboundMessageEphemeralInfo.GEN_ID, id);
            updateBuilder.updateColumnValue(OutboundMessageEphemeralInfo.VISIBILITY_TIMESTAMP, Long.valueOf(timestamp));
            updateBuilder.updateColumnValue(OutboundMessageEphemeralInfo.RETAIN_WIPED_MESSAGE, retainWipedMessage);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("OutboundMessageEphemeralInfoDao.updateVisibilityExpiration: unable to update", e);
        }
    }
}

