/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.ephemerality;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public class InboundMessageEphemeralInfoDao
extends AbstractMessageEphemeralInfoDao<InboundMessage, InboundMessageEphemeralInfo> {
    public InboundMessageEphemeralInfoDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, InboundMessageEphemeralInfo.class, "inbound_message_ephemeral_info_table");
    }

    @Override
    protected ObvQueryBuilder<InboundMessage> messageQueryBuilder(Id<Discussion> discussionId) throws SQLException {
        ObvQueryBuilder<InboundMessage> queryBuilder = DbManager.getInstance().getInboundMessageDao().queryBuilder();
        queryBuilder.where().eq(InboundMessage.FK_DISCUSSION, discussionId);
        return queryBuilder;
    }

    @Override
    protected Column.ForeignColumn<InboundMessage, InboundMessageEphemeralInfo> getEphemeralInfoColumn() {
        return InboundMessage.FK_INBOUND_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected Optional<Id<InboundMessageEphemeralInfo>> getInfoId(InboundMessage inboundMessage) {
        return inboundMessage.getInboundMessageEphemeralInfoId();
    }

    @Override
    protected void clearVisibilityExpirationInfoAux(ObvUpdateBuilder<InboundMessageEphemeralInfo> updateBuilder) throws SQLException {
    }

    public void updateVisibilityExpiration(Id<InboundMessageEphemeralInfo> id, long timestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(InboundMessageEphemeralInfo.GEN_ID, id);
            updateBuilder.updateColumnValue(InboundMessageEphemeralInfo.VISIBILITY_TIMESTAMP, Long.valueOf(timestamp));
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("InboundMessageEphemeralInfoDao.updateVisibilityExpiration: unable to update", e);
        }
    }
}

