/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.common;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.livedata.ContextLiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class OlvidDao<T extends AbstractTableGenerated<T>>
extends OlvidAbstractDao<T> {
    private ContextLiveData<T> contextLiveData;

    protected OlvidDao(ConnectionSource singleConnectionSource, Class<T> tableTypeClass) throws SQLException {
        super(singleConnectionSource, tableTypeClass);
    }

    public synchronized ContextLiveData<T> getContextLiveData() {
        if (this.contextLiveData == null) {
            this.contextLiveData = new ContextLiveData(this, ids -> LiveDataFactory.buildDbLiveDataList(this.getDataClass(), () -> this.get((Collection<Id<T>>)ids)));
        }
        return this.contextLiveData;
    }

    public T get(Id<T> id) {
        if (id == null) {
            AppLogger.e("Invalid parameter: get");
            return null;
        }
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            return (T)queryBuilder.where().eq(AbstractTableGenerated.GEN_ID, id).queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("get(ID id): Unable to query", throwables);
            return null;
        }
    }

    public List<T> get(Collection<Id<T>> ids) {
        this.checkThread();
        if (ids == null) {
            AppLogger.e("Invalid parameters: get");
            return null;
        }
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            return queryBuilder.where().in(AbstractTableGenerated.GEN_ID, ids).query();
        }
        catch (SQLException throwables) {
            AppLogger.e("get(Iterable<ID> ids): Unable to query", throwables);
            return null;
        }
    }
}

