/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.common;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DatabaseResultsMapper;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class OlvidBaseDao<T, ID>
extends BaseDaoImpl<T, ID> {
    private final LinkedHashSet<Dao.DaoObserver> registeredObservers = new LinkedHashSet();

    OlvidBaseDao(ConnectionSource singleConnectionSource, Class<T> tableTypeClass) throws SQLException {
        super(singleConnectionSource, tableTypeClass);
    }

    public T createIfNotExists(T entity) {
        try {
            return (T)super.createIfNotExists(entity);
        }
        catch (SQLException sqlException) {
            AppLogger.e("Unable to insert element", sqlException);
            return null;
        }
    }

    @SafeVarargs
    public final void insert(T ... instancesToInsert) {
        this.checkThread();
        try {
            this.insertOrThrow(instancesToInsert);
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed insert...", throwables);
        }
    }

    @SafeVarargs
    public final void insertOrThrow(T ... instancesToInsert) throws SQLException {
        this.checkThread();
        List<T> instancesToAdd = Arrays.asList(instancesToInsert);
        int ret = this.create(instancesToAdd);
        if (ret != instancesToInsert.length) {
            throw new SQLException("Uncomplete insert : " + ret + "/" + instancesToInsert.length);
        }
    }

    public int update(T instancesToInsert) {
        try {
            return this.updateOrThrow(instancesToInsert);
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed update...", throwables);
            return 0;
        }
    }

    public int updateOrThrow(T instancesToInsert) throws SQLException {
        this.checkThread();
        return super.update(instancesToInsert);
    }

    public int upsert(T instancesToInsert) {
        this.checkThread();
        try {
            Dao.CreateOrUpdateStatus createOrUpdateStatus = super.createOrUpdate(instancesToInsert);
            return createOrUpdateStatus.getNumLinesChanged();
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed update...", throwables);
            return -1;
        }
    }

    public void customDelete(List<T> instancesToDelete) {
        this.checkThread();
        try {
            int ret = this.delete(instancesToDelete);
            if (ret != instancesToDelete.size()) {
                throw new SQLException("Uncomplete delete : " + ret + "/" + instancesToDelete.size());
            }
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed delete...", throwables);
        }
    }

    public final void customDeleteById(ID id) {
        try {
            this.deleteById(id);
        }
        catch (Exception e) {
            AppLogger.e("Failed to delete...", e);
        }
    }

    @SafeVarargs
    public final void customDelete(T ... instancesToDelete) {
        this.checkThread();
        try {
            List<T> instancesToAdd = Arrays.asList(instancesToDelete);
            int ret = this.delete(instancesToAdd);
            if (ret != instancesToDelete.length) {
                throw new SQLException("Uncomplete delete : " + ret + "/" + instancesToDelete.length);
            }
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed delete...", throwables);
        }
    }

    public int update(String idColumnName, long id, Map<String, Object> keyAndValuesToUpdate) {
        UpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(idColumnName, (Object)id);
            for (String key : keyAndValuesToUpdate.keySet()) {
                updateBuilder.updateColumnValue(key, keyAndValuesToUpdate.get(key));
            }
            return updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("dao: update(Map<String, Object> keyAndValuesToUpdate)", e);
            return 0;
        }
    }

    public List<T> getAll() {
        QueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAll(): Unable to query", throwables);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerObserverWithRet(Dao.DaoObserver observer) {
        boolean added = false;
        if (observer != null) {
            LinkedHashSet<Dao.DaoObserver> linkedHashSet = this.registeredObservers;
            synchronized (linkedHashSet) {
                added = this.registeredObservers.add(observer);
            }
        }
        return added;
    }

    public void registerObserver(Dao.DaoObserver observer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserver(Dao.DaoObserver observer) {
        LinkedHashSet<Dao.DaoObserver> linkedHashSet = this.registeredObservers;
        synchronized (linkedHashSet) {
            this.registeredObservers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanges() {
        Dao.DaoObserver[] daoObserverArray = this.registeredObservers;
        synchronized (this.registeredObservers) {
            Dao.DaoObserver[] tmp = this.registeredObservers.toArray(new Dao.DaoObserver[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            AppLogger.t("====== notifyChanges " + this.dataClass.getSimpleName() + " for " + tmp.length);
            for (Dao.DaoObserver observer : tmp) {
                observer.onChange();
            }
            return;
        }
    }

    public <UO> UO queryRaw(String query, DatabaseResultsMapper<UO> mapper, List<Pair<FieldType, Object>> arguments, Long limit, boolean cacheStore) {
        FieldType[] fieldTypes = new FieldType[arguments.size()];
        ArgumentHolder[] argHolders = new ArgumentHolder[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            FieldType fieldType;
            Pair<FieldType, Object> argument = arguments.get(0);
            fieldTypes[i] = fieldType = argument.getFirst();
            argHolders[i] = new SelectArg(fieldType.getSqlType(), argument.getSecond());
        }
        MappedPreparedStmt preparedStmt = new MappedPreparedStmt((Dao)this, this.tableInfo, query, fieldTypes, this.getTableInfo().getFieldTypes(), argHolders, limit, StatementBuilder.StatementType.SELECT, cacheStore);
        try {
            CompiledStatement compiledStatement = preparedStmt.compile(DbManager.getInstance().getConnectionSource().getReadOnlyConnection(this.tableInfo.getTableName()), StatementBuilder.StatementType.SELECT);
            DatabaseResults databaseResults = compiledStatement.runQuery(this.getObjectCache());
            return (UO)mapper.mapRow(databaseResults);
        }
        catch (SQLException throwable) {
            AppLogger.e("Cannot perform queryRaw", throwable);
            return null;
        }
    }

    void checkThread() {
        if (DbManager.isOnUIThread()) {
            AppLogger.e(String.format("Using %s Dao for query/statement on UI thread....don't do that ", this.getTableName()));
        }
    }
}

