/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.attachment;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.interfaces.DaoWithForeignMessage;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public class OutboundAttachmentDao
extends AbstractAttachmentDao<OutboundMessage, OutboundAttachment>
implements DaoWithForeignMessage.Outbound {
    public OutboundAttachmentDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OutboundAttachment.class);
    }

    @Override
    public Id<OutboundMessage> getMessageId(OutboundAttachment outboundAttachment) {
        return outboundAttachment.getMessageId();
    }

    @Override
    public Column.ForeignColumn<OutboundAttachment, OutboundMessage> getMessageColumn() {
        return OutboundAttachment.FK_MESSAGE;
    }

    public Long getDiscussionCopyingAttachmentsCount(Id<Discussion> discussionGenId) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().eq(OutboundAttachment.FK_DISCUSSION, discussionGenId).and().eq(OutboundAttachment.STATUS, OutboundAttachmentGenerated.Status.COPYING);
            return queryBuilder.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionCopyingAttachmentsCount: Unable to query", throwables);
            return null;
        }
    }

    public List<OutboundAttachment> getMessageAttachments(Id<OutboundMessage> messageId, EnumSet<OutboundAttachmentGenerated.Status> statuses) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(OutboundAttachment.FK_MESSAGE, messageId).and().in(OutboundAttachment.STATUS, statuses);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionDraftAndCopyingAttachments: Unable to query", throwables);
            return null;
        }
    }

    public List<OutboundAttachment> getDiscussionDraftAndCopyingAttachments(Id<Discussion> discussionGenId) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        EnumSet<OutboundAttachmentGenerated.Status> statuses = EnumSet.of(OutboundAttachmentGenerated.Status.COPYING, OutboundAttachmentGenerated.Status.DRAFT_READY);
        try {
            queryBuilder.where().eq(OutboundAttachment.FK_DISCUSSION, discussionGenId).and().in(OutboundAttachment.STATUS, statuses);
            queryBuilder.orderBy(OutboundAttachment.IDX, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionDraftAndCopyingAttachments: Unable to query", throwables);
            return Collections.emptyList();
        }
    }

    public List<OutboundAttachment> getDiscussionDraftAttachments(Id<Discussion> discussionGenId) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        EnumSet<OutboundAttachmentGenerated.Status> statuses = EnumSet.of(OutboundAttachmentGenerated.Status.COPYING, OutboundAttachmentGenerated.Status.DRAFT_READY);
        try {
            queryBuilder.where().eq(OutboundAttachment.FK_DISCUSSION, discussionGenId).and().in(OutboundAttachment.STATUS, statuses);
            queryBuilder.orderBy(OutboundAttachment.IDX, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionDraftAndCopyingAttachments: Unable to query", throwables);
            return Collections.emptyList();
        }
    }

    public Long getDiscussionDraftAndCopyingAttachmentsCount(Discussion discussion) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            ObvWhere where = queryBuilder.where();
            where.and(where.eq(OutboundAttachment.FK_DISCUSSION, discussion), where.or(where.eq(OutboundAttachment.STATUS, OutboundAttachmentGenerated.Status.COPYING), where.eq(OutboundAttachment.STATUS, OutboundAttachmentGenerated.Status.DRAFT_READY)));
            return queryBuilder.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionDraftAndCopyingAttachments: Unable to query", throwables);
            return null;
        }
    }

    public OutboundAttachment getDraftByHashAndDiscussion(byte[] sha256, Discussion discussion) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        ObvQueryBuilder fyleQB = DbManager.getInstance().getFyleDao().queryBuilder();
        if (sha256 == null || discussion == null) {
            AppLogger.e("Invalid parameters: getDraftByHashAndDiscussion");
            return null;
        }
        try {
            fyleQB.where().eq(Fyle.SHA256, sha256);
            queryBuilder.where().eq(OutboundAttachment.FK_DISCUSSION, discussion).and().eq(OutboundAttachment.STATUS, OutboundAttachmentGenerated.Status.DRAFT_READY);
            queryBuilder.join(OutboundAttachment.FK_FYLE, Fyle.GEN_ID, fyleQB);
            return (OutboundAttachment)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDraftByHashAndDiscussion: Unable to query", throwables);
            return null;
        }
    }

    public Optional<OutboundAttachment> getLinkPreviewAttachment(Id<Discussion> itemId) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (itemId == null) {
            AppLogger.e("Invalid parameters: getDraftByHashAndDiscussion");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(OutboundAttachment.FK_DISCUSSION, itemId).and().eq(OutboundAttachment.MIME_TYPE, "olvid/link-preview").and().eq(OutboundAttachment.STATUS, OutboundAttachmentGenerated.Status.DRAFT_READY);
            return Optional.ofNullable((OutboundAttachment)queryBuilder.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("getLinkPreviewAttachment: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public void updateStatusForMessage(Id<OutboundMessage> messageId, OutboundAttachmentGenerated.Status status) throws SQLException {
        this.checkThread();
        if (status == null) {
            AppLogger.e("Invalid parameters: updateStatusForDiscussion");
            return;
        }
        ObvUpdateBuilder outboundAttachmentQB = this.updateBuilder();
        outboundAttachmentQB.updateColumnValue(OutboundAttachment.STATUS, status).where().eq(OutboundAttachment.FK_MESSAGE, messageId);
        if (outboundAttachmentQB.update() == 0) {
            throw new SQLException("updateStatusForDiscussion: Unable to update");
        }
    }

    public void updateAttachmentStatusFyleAndSize(OutboundAttachment outboundAttachment, OutboundAttachmentGenerated.Status status, Id<Fyle> fyleId, long size) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(OutboundAttachment.GEN_ID, outboundAttachment.getItemId());
            updateBuilder.updateColumnValue(OutboundAttachment.STATUS, status);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(OutboundAttachment.FK_FYLE, fyleId);
            updateBuilder.updateColumnValue(OutboundAttachment.SIZE, size);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateAttachmentStatusProgressFyleAndSize: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateAttachmentStatusProgressFyleAndSize: Unable to update");
        }
    }

    public boolean updateStatus(Id<OutboundAttachment> id, OutboundAttachmentGenerated.Status status) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(OutboundAttachment.GEN_ID, id);
            updateBuilder.updateColumnValue(OutboundAttachment.STATUS, status);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateStatus: Unable to update");
                return false;
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateStatus: Unable to update");
            return false;
        }
        return true;
    }

    public int deletePostedDraft(int attachmentNumber) {
        this.checkThread();
        try {
            ObvDeleteBuilder attachmentRecipientInfoUB = this.deleteBuilder();
            attachmentRecipientInfoUB.where().eq(OutboundAttachment.IDX, attachmentNumber);
            if (attachmentRecipientInfoUB.delete() == 0) {
                throw new SQLException("deletePostedDraft: Unable to update");
            }
        }
        catch (SQLException throwables) {
            AppLogger.e("deletePostedDraft: Unable to query", throwables);
        }
        return 0;
    }

    public Optional<OutboundAttachment> getFromIndexAndMessageIdentifier(byte[] ownedIdentityBytes, byte[] engineMessageIdentifier, int index) {
        this.checkThread();
        try {
            ObvQueryBuilder attachmentRecipientInfoQB = DbManager.getInstance().getAttachmentRecipientInfoDao().queryBuilder();
            ObvQueryBuilder outboundAttachmentQB = DbManager.getInstance().getOutboundAttachmentDao().queryBuilder();
            ObvQueryBuilder ownedIdentityQB = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
            ownedIdentityQB.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, ownedIdentityBytes);
            outboundAttachmentQB.where().eq(OutboundAttachment.IDX, index);
            outboundAttachmentQB.join(OutboundAttachment.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, ownedIdentityQB);
            attachmentRecipientInfoQB.where().eq(AttachmentRecipientInfo.ENGINE_MESSAGE_IDENTIFIER, engineMessageIdentifier);
            outboundAttachmentQB.join(OutboundAttachment.GEN_ID, AttachmentRecipientInfo.FK_ATTACHMENT, attachmentRecipientInfoQB);
            return Optional.ofNullable((OutboundAttachment)outboundAttachmentQB.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("getDraftByHashAndDiscussion: Unable to query", throwables);
            return null;
        }
    }
}

