/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class PreGroupDao
extends OlvidDao<PreGroup> {
    public PreGroupDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, PreGroup.class);
    }

    public PreGroup get(byte[] bytesOwnedIdentity, byte[] bytesIdentifier) {
        this.checkThread();
        ObvQueryBuilder preGroupQB = this.queryBuilder();
        ObvQueryBuilder ownedIdentityQB = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        if (bytesOwnedIdentity == null || bytesIdentifier == null) {
            AppLogger.e("PreGroupDao: get: invalid arguments");
            return null;
        }
        try {
            ownedIdentityQB.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            preGroupQB.join(PreGroup.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, ownedIdentityQB);
            preGroupQB.where().eq(PreGroup.BYTES_GROUP_IDENTIFIER, bytesIdentifier);
            return (PreGroup)preGroupQB.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("PreGroupDao: Unable to query: get", throwables);
            return null;
        }
    }

    public List<PreGroup> getAllPreGroupsWithSpecificContact(Id<Contact> contactId) {
        this.checkThread();
        try {
            ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
            contactRefQB.where().eq(ContactRef.FK_CONTACT, contactId);
            ObvQueryBuilder pendingGroupMemberQB = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
            pendingGroupMemberQB.join(PendingGroupMember.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
            ObvQueryBuilder queryBuilder = this.queryBuilder();
            queryBuilder.join(PreGroup.GEN_ID, PendingGroupMember.FK_PRE_GROUP, pendingGroupMemberQB);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getAllPreGroupsWithSpecificContact", throwables);
            return Collections.emptyList();
        }
    }
}

