/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class PendingGroupMemberDao
extends OlvidDao<PendingGroupMember> {
    public PendingGroupMemberDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, PendingGroupMember.class);
    }

    private ObvQueryBuilder<PendingGroupMember> getMemberPreparedQB(Group group, byte[] bytesContactIdentity) {
        this.checkThread();
        ObvQueryBuilder<PendingGroupMember> qb = this.queryBuilder();
        ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
        if (bytesContactIdentity == null || group == null) {
            return null;
        }
        try {
            contactRefQB.where().eq(ContactRef.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            qb.join(PendingGroupMember.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
            qb.where().eq(PendingGroupMember.FK_GROUP, group);
            return qb;
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: get ", throwables);
            return null;
        }
    }

    public PendingGroupMember getMember(Group group, byte[] bytesContactIdentity) {
        this.checkThread();
        ObvQueryBuilder<PendingGroupMember> preparedQuery = this.getMemberPreparedQB(group, bytesContactIdentity);
        if (preparedQuery != null) {
            try {
                return (PendingGroupMember)this.queryBuilder().queryForFirst();
            }
            catch (SQLException e) {
                AppLogger.e("PendingGroupMember: getMember ", e);
            }
        }
        return null;
    }

    public long getMemberCount(Group group, byte[] bytesContactIdentity) {
        this.checkThread();
        ObvQueryBuilder<PendingGroupMember> preparedQuery = this.getMemberPreparedQB(group, bytesContactIdentity);
        if (preparedQuery != null) {
            try {
                return this.queryBuilder().countOf();
            }
            catch (SQLException e) {
                AppLogger.e("PendingGroupMember: getMemberCount ", e);
            }
        }
        return 0L;
    }

    public List<PendingGroupMember> getPendingMembers(Group group) {
        this.checkThread();
        ObvQueryBuilder pendingQb = this.queryBuilder();
        try {
            pendingQb.where().eq(PendingGroupMember.FK_GROUP, group);
            return pendingQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: getPendingMembersForGroup", throwables);
            return null;
        }
    }

    public List<PendingGroupMember> getPendingMembers(PreGroup preGroup) {
        this.checkThread();
        ObvQueryBuilder pendingQb = this.queryBuilder();
        try {
            pendingQb.where().eq(PendingGroupMember.FK_PRE_GROUP, preGroup);
            return pendingQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: getPendingMembersForGroup", throwables);
            return null;
        }
    }

    public Optional<PendingGroupMember> getUnknownPendingMember(Id<ContactRef> contactRefId) {
        this.checkThread();
        ObvQueryBuilder pendingQb = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
        try {
            contactRefQB.where().eq(OutboundMessage.GEN_ID, contactRefId).and().isNull(ContactRef.FK_CONTACT);
            pendingQb.join(PendingGroupMember.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
            return Optional.ofNullable((PendingGroupMember)pendingQb.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: getUnknownPendingMembers", throwables);
            return Optional.empty();
        }
    }

    public int pendingUpdateDeclined(PendingGroupMember pendingGroupMember) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(PendingGroupMember.DECLINED, pendingGroupMember.isDeclined());
            updateBuilder.where().eq(PendingGroupMember.GEN_ID, pendingGroupMember.getItemId());
            return updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: get ", throwables);
            return -1;
        }
    }

    public int upgradeFromPreGroupToGroup(PreGroup preGroup, Group group) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            ((AbstractObvUpdateBuilder)((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(PendingGroupMember.FK_PRE_GROUP, (PreGroup)null)).updateColumnValue(PendingGroupMember.FK_GROUP, group.getItemId());
            updateBuilder.where().eq(PendingGroupMember.FK_PRE_GROUP, preGroup);
            return updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("PendingGroupMember: get ", throwables);
            return -1;
        }
    }
}

