/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class OwnedDeviceDao
extends OlvidDao<OwnedDevice> {
    public OwnedDeviceDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, OwnedDevice.class);
    }

    public void customRefresh(OwnedDevice ownedDevice) {
        try {
            this.refresh(ownedDevice);
        }
        catch (SQLException throwables) {
            AppLogger.e("OwnedDevice: unable to refresh", throwables);
        }
    }

    public void updateChannelConfirmed(Id<OwnedDevice> ownedDeviceId, boolean isChannelConfirmed) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedDevice.GEN_ID, ownedDeviceId);
            updateBuilder.updateColumnValue(OwnedDevice.CHANNEL_CONFIRMED, isChannelConfirmed);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateChannelConfirmed: Unable to update", throwables);
        }
    }

    public void updateCurrentDevice(Id<OwnedDevice> ownedDeviceId, boolean isCurrentDevice) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedDevice.GEN_ID, ownedDeviceId);
            updateBuilder.updateColumnValue(OwnedDevice.CURRENT_DEVICE, isCurrentDevice);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateCurrentDevice: Unable to update", throwables);
        }
    }

    public void updateDisplayName(Id<OwnedDevice> ownedDeviceId, Optional<String> displayName) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedDevice.GEN_ID, ownedDeviceId);
            updateBuilder.updateColumnValue(OwnedDevice.DISPLAY_NAME, displayName.orElse(null));
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateDisplayName: Unable to update", throwables);
        }
    }

    public void updateTimestamps(Id<OwnedDevice> ownedDeviceId, Long lastRegistrationTimestamp, Long expirationTimestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedDevice.GEN_ID, ownedDeviceId);
            updateBuilder.updateColumnValue(OwnedDevice.LAST_REGISTRATION_TIMESTAMP, lastRegistrationTimestamp);
            updateBuilder.updateColumnValue(OwnedDevice.EXPIRATION_TIMESTAMP, expirationTimestamp);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateDisplayName: Unable to update", throwables);
        }
    }

    public void updateHasPrekey(Id<OwnedDevice> itemId, boolean hasPrekey) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedDevice.GEN_ID, itemId);
            updateBuilder.updateColumnValue(OwnedDevice.HAS_PREKEY, hasPrekey);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateHasPrekey: Unable to update", throwables);
        }
    }

    public List<OwnedDevice> getAllSync(Id<OwnedIdentity> ownedIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().eq(OwnedDevice.FK_OWNED_IDENTITY, ownedIdentity);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllSync: Unable to query", throwables);
            return null;
        }
    }

    public boolean doesOwnedIdentityHaveAnotherDeviceWithChannel(Id<OwnedIdentity> ownedIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (ownedIdentity == null) {
            this.logger.error("Invalid parameters: doesOwnedIdentityHaveAnotherDeviceWithChannel(byte[] fkaOwnedIdentity)");
        }
        try {
            queryBuilder.where().eq(OwnedDevice.FK_OWNED_IDENTITY, ownedIdentity).and().eq(OwnedDevice.CURRENT_DEVICE, false).and().eq(OwnedDevice.CHANNEL_CONFIRMED, true);
            return queryBuilder.queryForFirst() != null;
        }
        catch (SQLException throwables) {
            AppLogger.e("doesOwnedIdentityHaveAnotherDeviceWithChannel: Unable to query", throwables);
            return false;
        }
    }
}

