/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.KnownCertificate;
import java.sql.SQLException;
import java.util.List;

public class KnownCertificateDao
extends OlvidDao<KnownCertificate> {
    public KnownCertificateDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, KnownCertificate.class);
    }

    public List<KnownCertificate> getAllForDomain(String domainName) {
        ObvQueryBuilder knownCertificateLongQB = this.queryBuilder();
        try {
            knownCertificateLongQB.where().eq(KnownCertificate.DOMAIN_NAME, domainName);
            knownCertificateLongQB.orderBy(KnownCertificate.TRUST_TIMESTAMP, false);
            return knownCertificateLongQB.query();
        }
        catch (SQLException exception) {
            this.logger.error("KnownCertificateDao::getAllForDomain Couldn't get domains from db", exception);
            return null;
        }
    }

    public void deleteExpired(String domainName, long currentTime) {
        ObvQueryBuilder knownCertificateLongQB = this.queryBuilder();
        try {
            knownCertificateLongQB.where().eq(KnownCertificate.DOMAIN_NAME, domainName).and().lt(KnownCertificate.EXPIRATION_TIMESTAMP, currentTime);
            knownCertificateLongQB.query();
        }
        catch (SQLException exception) {
            this.logger.error("KnownCertificateDao::deleteExpired Couldn't get delete expired knownCertificates from db", exception);
        }
    }
}

