/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public class GroupMemberPermissionsDao
extends OlvidDao<GroupMemberPermissions> {
    public GroupMemberPermissionsDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, GroupMemberPermissions.class);
    }

    public List<GroupMemberPermissions> getMemberPermissionsFromGroup(Group group) {
        this.checkThread();
        ObvQueryBuilder groupMemberPermissionQb = this.queryBuilder();
        ObvQueryBuilder contactGroupJoinLongQB = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        try {
            contactGroupJoinLongQB.where().eq(ContactGroupJoin.FK_GROUP, group);
            groupMemberPermissionQb.join(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN, ContactGroupJoin.GEN_ID, contactGroupJoinLongQB);
            groupMemberPermissionQb.where().isNull(GroupMemberPermissions.FK_GROUP).and().isNull(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER);
            return groupMemberPermissionQb.query();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public List<GroupMemberPermissions> getAllPendingMembersPermissions(Group group) {
        this.checkThread();
        ObvQueryBuilder groupMemberPermissionQb = this.queryBuilder();
        ObvQueryBuilder groupPendingMemberQB = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        try {
            groupPendingMemberQB.where().eq(PendingGroupMember.FK_GROUP, group);
            groupMemberPermissionQb.join(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER, PendingGroupMember.GEN_ID, groupPendingMemberQB);
            groupMemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, group.getOwnedIdentityId()).and().isNull(GroupMemberPermissions.FK_GROUP).and().isNull(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN);
            return groupMemberPermissionQb.query();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public List<GroupMemberPermissions> getAllPendingMembersPermissions(PreGroup preGroup) {
        this.checkThread();
        ObvQueryBuilder groupMemberPermissionQb = this.queryBuilder();
        ObvQueryBuilder groupPendingMemberQB = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        try {
            groupPendingMemberQB.where().eq(PendingGroupMember.FK_PRE_GROUP, preGroup);
            groupMemberPermissionQb.join(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER, PendingGroupMember.GEN_ID, groupPendingMemberQB);
            groupMemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, preGroup.getOwnedIdentityId()).and().isNull(GroupMemberPermissions.FK_GROUP).and().isNull(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN);
            return groupMemberPermissionQb.query();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public GroupMemberPermissions getOwnPermission(Id<Group> group) {
        this.checkThread();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_GROUP, group).and().isNull(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER).and().isNull(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN).and().isNull(GroupMemberPermissions.FK_PRE_GROUP);
            return (GroupMemberPermissions)groupV2MemberPermissionQb.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public GroupMemberPermissions getOwnPermission(PreGroup preGroup) {
        this.checkThread();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, preGroup.getOwnedIdentityId()).and().eq(GroupMemberPermissions.FK_PRE_GROUP, preGroup).and().isNull(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER).and().isNull(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN).and().isNull(GroupMemberPermissions.FK_GROUP);
            return (GroupMemberPermissions)groupV2MemberPermissionQb.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public GroupMemberPermissions getMemberPermissions(Id<OwnedIdentity> ownedIdentity, Id<Contact> contact, Id<Group> group) {
        this.checkThread();
        ObvQueryBuilder contactGroupJoinQB = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            contactGroupJoinQB.where().eq(ContactGroupJoin.FK_GROUP, group).and().eq(ContactGroupJoin.FK_CONTACT, contact).and().eq(ContactGroupJoin.FK_OWNED_IDENTITY, ownedIdentity);
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, ownedIdentity);
            groupV2MemberPermissionQb.join(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN, ContactGroupJoin.GEN_ID, contactGroupJoinQB);
            return (GroupMemberPermissions)groupV2MemberPermissionQb.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public GroupMemberPermissions getPendingMemberPermissions(Id<OwnedIdentity> ownedIdentity, ContactRef contactRef, Id<Group> groupId) {
        this.checkThread();
        ObvQueryBuilder pendingGroupMemberQB = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            pendingGroupMemberQB.where().eq(PendingGroupMember.FK_GROUP, groupId).and().eq(PendingGroupMember.FK_CONTACT_REF, contactRef);
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, ownedIdentity);
            groupV2MemberPermissionQb.join(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER, PendingGroupMember.GEN_ID, pendingGroupMemberQB);
            return (GroupMemberPermissions)groupV2MemberPermissionQb.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public GroupMemberPermissions getMemberPermissions(OwnedIdentity ownedIdentity, byte[] bytesContactIdentifier, byte[] groupIdentifier) {
        this.checkThread();
        ObvQueryBuilder contactQueryBuilder = DbManager.getInstance().getContactDao().queryBuilder();
        ObvQueryBuilder groupQueryBuilder = DbManager.getInstance().getGroupDao().queryBuilder();
        ObvQueryBuilder contactGroupJoinQB = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            contactQueryBuilder.where().eq(Contact.BYTES_CONTACT_IDENTITY, bytesContactIdentifier).and().eq(Contact.FK_OWNED_IDENTITY, ownedIdentity);
            groupQueryBuilder.where().eq(Group.BYTES_GROUP_IDENTIFIER, groupIdentifier).and().eq(Group.FK_OWNED_IDENTITY, ownedIdentity);
            contactGroupJoinQB.join(ContactGroupJoin.FK_CONTACT, Contact.GEN_ID, contactQueryBuilder);
            contactGroupJoinQB.join(ContactGroupJoin.FK_GROUP, Group.GEN_ID, groupQueryBuilder);
            groupV2MemberPermissionQb.join(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN, ContactGroupJoin.GEN_ID, contactGroupJoinQB);
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, ownedIdentity).and().isNull(GroupMemberPermissions.FK_GROUP);
            return (GroupMemberPermissions)groupV2MemberPermissionQb.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public ContactGroupJoin getOwnerContactGroupJoin(Group group) {
        this.checkThread();
        ObvQueryBuilder contactGroupJoinQB = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        ObvQueryBuilder groupV2MemberPermissionQb = this.queryBuilder();
        try {
            groupV2MemberPermissionQb.where().eq(GroupMemberPermissions.FK_OWNED_IDENTITY, group.getOwnedIdentityId()).and().eq(GroupMemberPermissions.ADMIN, true);
            contactGroupJoinQB.where().eq(ContactGroupJoin.FK_GROUP, group).and().eq(ContactGroupJoin.FK_OWNED_IDENTITY, group.getOwnedIdentityId());
            contactGroupJoinQB.join(ContactGroupJoin.GEN_ID, GroupMemberPermissions.FK_CONTACT_GROUP_JOIN, groupV2MemberPermissionQb);
            return (ContactGroupJoin)contactGroupJoinQB.queryForFirst();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupV2MemberDao::getGroupMembersNames: Unable to query ", sqlException);
            return null;
        }
    }

    public List<GroupMemberPermissions> getAllOthersPermissionsForGroup(Id<Group> groupId) {
        List list;
        block8: {
            this.checkThread();
            String query = "SELECT group_member_permissions_table.* FROM group_member_permissions_table JOIN contact_group_join_table ON " + String.valueOf(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN) + " = contact_group_join_table." + String.valueOf(ContactGroupJoin.GEN_ID) + " AND contact_group_join_table." + String.valueOf(ContactGroupJoin.FK_GROUP) + " = " + groupId.getId() + " UNION SELECT group_member_permissions_table.* from group_member_permissions_table JOIN pending_group_member_table ON " + String.valueOf(GroupMemberPermissions.FK_PENDING_GROUP_MEMBER) + " = pending_group_member_table." + String.valueOf(PendingGroupMember.GEN_ID) + " AND pending_group_member_table." + String.valueOf(PendingGroupMember.FK_GROUP) + " = " + groupId.getId();
            GenericRawResults genericRawResults = this.queryRaw(query, result -> GroupMemberPermissions.mapRow(result, ""));
            try {
                list = genericRawResults.getResults();
                if (genericRawResults == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (genericRawResults != null) {
                        try {
                            genericRawResults.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AppLogger.e("GroupV2MemberDao::getAllPendingMembersPermissions: Unable to query ", e);
                    return List.of();
                }
            }
            genericRawResults.close();
        }
        return list;
    }
}

