/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class GroupDao
extends OlvidDao<Group> {
    public GroupDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Group.class);
    }

    public Group get(Group group) {
        this.checkThread();
        try {
            if (this.refresh(group) != 1) {
                AppLogger.w("GroupDao::getFromV1: Couldn't find element to refresh...");
                return null;
            }
            return group;
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupDao::get: Unable to query ", sqlException);
            return null;
        }
    }

    public List<Group> getGroupsAssociatedToIdentity(Id<OwnedIdentity> ownedIdentityId) {
        this.checkThread();
        ObvQueryBuilder groupQb = this.queryBuilder();
        try {
            groupQb.where().eq(Group.FK_OWNED_IDENTITY, ownedIdentityId);
            return groupQb.query();
        }
        catch (SQLException sqlException) {
            AppLogger.e("GroupDao::getGroupsAssociatedToIdentity: Unable to query ", sqlException);
            return null;
        }
    }

    public void updateNamePhotoAndDetails(Group group, String name, String photoUrl, String description) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Group.NAME, name);
            updateBuilder.updateColumnValue(Group.PHOTO_URL, photoUrl);
            updateBuilder.updateColumnValue(Group.DESCRIPTION, description);
            updateBuilder.where().eq(Group.GEN_ID, group.getItemId());
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateNamePhotoAndDetails: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateNamePhotoAndDetails: Unable to update");
        }
    }

    public void updatePublishedDetailsStatus(Group group, GroupGenerated.PublishedDetails newPublishedDetails) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Group.NEW_PUBLISHED_DETAILS, newPublishedDetails);
            updateBuilder.where().eq(Group.GEN_ID, group.getItemId());
            if (updateBuilder.update() == 0) {
                AppLogger.e("updatePublishedDetailsStatus: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updatePublishedDetailsStatus: Unable to update");
        }
    }

    public int updateCustomPhotoUrl(Id<Group> group, String customPhotoUrl) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Group.CUSTOM_PHOTO_URL, customPhotoUrl);
            updateBuilder.where().eq(Group.GEN_ID, group);
            int updatedRowCount = updateBuilder.update();
            if (updatedRowCount == 0) {
                AppLogger.e("updateCustomPhotoUrl: Unable to update");
            }
            return updatedRowCount;
        }
        catch (SQLException e) {
            AppLogger.e("updateCustomPhotoUrl: Unable to update");
            return 0;
        }
    }

    public int updateCustomName(Id<Group> groupId, Optional<String> customName) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Group.CUSTOM_NAME, customName.orElse(null));
            updateBuilder.where().eq(Group.GEN_ID, groupId);
            int updatedRowCount = updateBuilder.update();
            if (updatedRowCount == 0) {
                AppLogger.e("updateCustomName: Unable to update");
            }
            return updatedRowCount;
        }
        catch (SQLException e) {
            AppLogger.e("updateCustomName: Unable to update");
            return 0;
        }
    }

    public int updatePersonalNote(Id<Group> groupId, Optional<String> personalNote) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Group.PERSONAL_NOTE, personalNote.orElse(null));
            updateBuilder.where().eq(Group.GEN_ID, groupId);
            int updatedRowCount = updateBuilder.update();
            if (updatedRowCount == 0) {
                AppLogger.e("updatePersonalNote: Unable to update");
            }
            return updatedRowCount;
        }
        catch (SQLException e) {
            AppLogger.e("updatePersonalNote: Unable to update");
            return 0;
        }
    }

    public Group get(OwnedIdentity ownedIdentity, byte[] bytesIdentifier) {
        this.checkThread();
        ObvQueryBuilder groupQB = this.queryBuilder();
        if (ownedIdentity == null || bytesIdentifier == null) {
            AppLogger.e("GroupDao: get: invalid arguments");
            return null;
        }
        try {
            groupQB.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesIdentifier).and().eq(Group.FK_OWNED_IDENTITY, ownedIdentity);
            return (Group)groupQB.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: get", throwables);
            return null;
        }
    }

    public Group get(Id<OwnedIdentity> ownedIdentity, byte[] bytesIdentifier) {
        this.checkThread();
        ObvQueryBuilder groupQB = this.queryBuilder();
        if (ownedIdentity == null || bytesIdentifier == null) {
            AppLogger.e("GroupDao: get: invalid arguments");
            return null;
        }
        try {
            groupQB.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesIdentifier).and().eq(Group.FK_OWNED_IDENTITY, ownedIdentity);
            return (Group)groupQB.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: get", throwables);
            return null;
        }
    }

    public void updateGroupMembersNames(OwnedIdentity fkaOwnedIdentity, byte[] bytesGroupIdentifier, String groupMembersNames) {
        this.checkThread();
        ObvUpdateBuilder ub = this.updateBuilder();
        try {
            ub.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupIdentifier).and().eq(Group.FK_OWNED_IDENTITY, fkaOwnedIdentity);
            ub.updateColumnValue(Group.GROUP_MEMBERS_NAMES, groupMembersNames);
            ub.update();
        }
        catch (SQLException throwables) {
            this.logger.error("Group#updateGroupMembersNames : unable to update ", throwables);
        }
    }

    public void updatePhotoUrl(OwnedIdentity fkaOwnedIdentity, byte[] bytesGroupIdentifier, Optional<String> photoUrl) {
        this.checkThread();
        ObvUpdateBuilder ub = this.updateBuilder();
        try {
            ub.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupIdentifier).and().eq(Group.FK_OWNED_IDENTITY, fkaOwnedIdentity);
            ub.updateColumnValue(Group.PHOTO_URL, photoUrl.orElse(null));
            ub.update();
        }
        catch (SQLException throwables) {
            this.logger.error("Group#updatePhotoUrl : unable to update ", throwables);
        }
    }

    public void updateUpdateInProgress(Id<OwnedIdentity> ownedIdentity, byte[] bytesGroupIdentifier, GroupGenerated.Update progress) {
        this.checkThread();
        ObvUpdateBuilder ub = this.updateBuilder();
        try {
            ub.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupIdentifier).and().eq(Group.FK_OWNED_IDENTITY, ownedIdentity);
            ub.updateColumnValue(Group.UPDATE_IN_PROGRESS, progress);
            ub.update();
        }
        catch (SQLException throwable) {
            this.logger.error("GroupUpdateUpdateInProgress : unable to update ", throwable);
        }
    }

    private List<Group> getAllGroupWithSpecificPendingMember(Id<Contact> contactId) throws SQLException {
        ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
        contactRefQB.where().eq(ContactRef.FK_CONTACT, contactId);
        ObvQueryBuilder pendingGroupMemberQB = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        pendingGroupMemberQB.join(PendingGroupMember.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        queryBuilder.join(Group.GEN_ID, PendingGroupMember.FK_GROUP, pendingGroupMemberQB);
        return queryBuilder.query();
    }

    public List<Group> getAllGroupWithSpecificMember(Id<Contact> contactId) throws SQLException {
        ObvQueryBuilder contactGroupJoinQB = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        contactGroupJoinQB.where().eq(ContactGroupJoin.FK_CONTACT, contactId);
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        queryBuilder.join(Group.GEN_ID, ContactGroupJoin.FK_GROUP, contactGroupJoinQB);
        return queryBuilder.query();
    }

    public List<Group> getAllGroupsWithSpecificContact(Id<Contact> contactId, boolean includePending) {
        this.checkThread();
        try {
            List<Group> groupWhereContactIsMember = this.getAllGroupWithSpecificMember(contactId);
            ArrayList<Group> groups = new ArrayList<Group>(groupWhereContactIsMember);
            if (includePending) {
                List<Group> groupWhereContactIsPendingMember = this.getAllGroupWithSpecificPendingMember(contactId);
                groups.addAll(groupWhereContactIsPendingMember);
            }
            groups.sort(OptionalUtils.OptionalComparator.of(Group::getDisplayName, OptionalUtils.OptionalComparator.EmptyOrder.EMPTY_LAST));
            return groups;
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getAllGroupsWithSpecificContact", throwables);
            return Collections.emptyList();
        }
    }
}

