/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;

public class FyleDao
extends OlvidDao<Fyle> {
    public FyleDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Fyle.class);
    }

    public int deleteWithRet(Fyle fyle) {
        try {
            return this.delete(fyle);
        }
        catch (SQLException sqlException) {
            AppLogger.e("Unable to delete fyle with genid : " + String.valueOf(fyle.getItemId()));
            return -1;
        }
    }

    public void updateFylePathAndHash(Fyle fyle, String filePath, byte[] sha256) {
        ObvUpdateBuilder queryBuilder = this.updateBuilder();
        this.checkThread();
        try {
            queryBuilder.updateColumnValue(Fyle.FILE_PATH, filePath);
            queryBuilder.updateColumnValue(Fyle.SHA256, sha256);
            queryBuilder.where().eq(Fyle.GEN_ID, fyle.getItemId());
            if (queryBuilder.update() == 0) {
                AppLogger.e("updateFylePathShaAndStatus: Unable to update");
            }
        }
        catch (SQLException throwables) {
            AppLogger.e("updateFylePathShaAndStatus: Unable to update");
        }
    }

    public Fyle getFromHash(byte[] sha256) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (sha256 == null) {
            AppLogger.e("Invalid parameters: doesHashAlreadyExists");
            return null;
        }
        try {
            queryBuilder.where().eq(Fyle.SHA256, sha256);
            return (Fyle)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("doesHashAlreadyExists: Unable to query", throwables);
            return null;
        }
    }
}

