/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class DiscussionDao
extends OlvidDao<Discussion> {
    public DiscussionDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Discussion.class);
    }

    public void updateLastMessageTimestamp(Discussion discussion, Long sortTimestamp) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(Discussion.GEN_ID, discussion.getItemId());
            updateBuilder.updateColumnValue(Discussion.SORT_TIMESTAMP, sortTimestamp);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateLastMessageTimestamp: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateLastMessageTimestamp: Unable to update");
        }
    }

    public void updateLastMessageWithTimestampIfNecessary(Discussion discussion, AbstractMessageGenerated<?> message, boolean forceUpdate) {
        this.checkThread();
        Optional<AbstractMessageGenerated<?>> lastMessageOpt = this.getLastMessage(discussion);
        if (lastMessageOpt.isPresent()) {
            AbstractMessageGenerated<?> lastMessage = lastMessageOpt.get();
            if (!forceUpdate && lastMessage.getTimestamp() > message.getTimestamp()) {
                return;
            }
        }
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(Discussion.GEN_ID, discussion.getItemId());
            if (message instanceof AbstractUserMessageGenerated) {
                AbstractUserMessageGenerated userMessage = (AbstractUserMessageGenerated)message;
                MessageRef messageRef = DbManager.getInstance().getMessageRefDao().getOrCreate(userMessage);
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_USER_MESSAGE_REF, messageRef.getItemId());
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_SYSTEM_MESSAGE, (SystemMessage)null);
            } else if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_USER_MESSAGE_REF, (MessageRef)null);
                ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_SYSTEM_MESSAGE, systemMessage.getItemId());
            } else {
                this.logger.error("DiscussionDao: updateLastMessageWithTimestamp: found unexpected type of message");
                return;
            }
            if (discussion.getSortTimestamp() < message.getTimestamp()) {
                updateBuilder.updateColumnValue(Discussion.SORT_TIMESTAMP, message.getTimestamp());
            }
            updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionDao: updateLastMessageWithTimestamp: sql exception", e);
        }
    }

    public void clearLastMessage(Discussion discussion) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(Discussion.GEN_ID, discussion.getItemId());
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_USER_MESSAGE_REF, (Id)null);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(Discussion.FK_LAST_SYSTEM_MESSAGE, (Id)null);
            updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionDao: updateLastMessageWithTimestamp: sql exception", e);
        }
    }

    public void updateLastOutboundMessageSequenceNumber(Discussion discussion) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Discussion.LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER, discussion.getLastOutboundMessageSequenceNumber());
            updateBuilder.where().eq(Discussion.GEN_ID, discussion.getItemId());
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateLastOutboundMessageSequenceNumber: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateLastOutboundMessageSequenceNumber: Unable to update");
        }
    }

    public void updateDiscussionStatus(Discussion discussion) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        if (discussion == null) {
            this.logger.error("DiscussionDao: updateDiscussionStatus: received null discussion");
            return;
        }
        try {
            updateBuilder.where().eq(Discussion.GEN_ID, discussion.getItemId());
            updateBuilder.updateColumnValue(Discussion.STATUS, discussion.getStatus());
            updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionDao: updateDiscussionStatus: sql exception", e);
        }
    }

    public Optional<Discussion> getWithContactBytes(Id<OwnedIdentity> ownedIdentity, byte[] contactBytes) {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        ObvQueryBuilder contactQb = DbManager.getInstance().getContactDao().queryBuilder();
        if (ownedIdentity == null || contactBytes == null) {
            this.logger.error("Invalid parameters: getDiscussionByIdentifier");
            return Optional.empty();
        }
        try {
            contactQb.where().eq(Contact.BYTES_CONTACT_IDENTITY, contactBytes);
            discussionQB.where().eq(Discussion.FK_OWNED_IDENTITY, ownedIdentity);
            discussionQB.join(Discussion.FK_CONTACT, Contact.GEN_ID, contactQb);
            return Optional.ofNullable((Discussion)discussionQB.queryForFirst());
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByIdentifier: Unable to query");
            return Optional.empty();
        }
    }

    public Discussion get(Contact contact) {
        return this.getByForeignKey(Discussion.FK_CONTACT, contact);
    }

    public Discussion get(Group group) {
        return this.getByForeignKey(Discussion.FK_GROUP, group);
    }

    public Discussion get(PreContact preContact) {
        return this.getByForeignKey(Discussion.FK_PRE_CONTACT, preContact);
    }

    public Discussion get(PreGroup preGroup) {
        return this.getByForeignKey(Discussion.FK_PRE_GROUP, preGroup);
    }

    private <F> Discussion getByForeignKey(Column.ForeignColumn<? super Discussion, F> fkColumnName, F fk) {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        if (fkColumnName == null || fk == null) {
            this.logger.error("Invalid parameters: getByForeignKey: " + String.valueOf(fkColumnName));
            return null;
        }
        try {
            discussionQB.where().eq(fkColumnName, fk);
            return (Discussion)discussionQB.queryForFirst();
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByContact: Unable to query: " + String.valueOf(fkColumnName));
            return null;
        }
    }

    public Discussion getDiscussionByIdentifier(Id<OwnedIdentity> ownedIdentity, byte[] bytesDiscussionIdentifier) {
        this.checkThread();
        try {
            return this.getDiscussionByIdentifierQB(ownedIdentity, bytesDiscussionIdentifier).queryForFirst();
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByIdentifier: Unable to query");
            return null;
        }
    }

    public ObvQueryBuilder<Discussion> getDiscussionByIdentifierQB(Id<OwnedIdentity> ownedIdentity, byte[] bytesDiscussionIdentifier) {
        this.checkThread();
        ObvQueryBuilder<Discussion> discussionQB = this.queryBuilder();
        if (ownedIdentity == null || bytesDiscussionIdentifier == null) {
            this.logger.error("Invalid parameters: getDiscussionByIdentifier");
            return null;
        }
        try {
            discussionQB.where().eq(Discussion.BYTES_DISCUSSION_IDENTIFIER, bytesDiscussionIdentifier).and().eq(Discussion.FK_OWNED_IDENTITY, ownedIdentity);
            return discussionQB;
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByIdentifier: Unable to query");
            return null;
        }
    }

    public List<Discussion> getAllDiscussionsSortedByIndex() {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            discussionQB.orderBy(Discussion.GEN_ID, true);
            return discussionQB.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("getAllDiscussionsSortedByIndex: Unable to query", sqlException);
            return null;
        }
    }

    public List<Discussion> getAllDiscussionsAssociatedToIdentitySortedByLastMessageTimestamp(Id<OwnedIdentity> ownedIdentityId) {
        return this.getDiscussionsAssociatedToIdentity(ownedIdentityId, true);
    }

    public List<Discussion> getVisibleDiscussionsAssociatedToIdentitySortedByLastMessageTimestamp(Id<OwnedIdentity> ownedIdentityId) {
        return this.getDiscussionsAssociatedToIdentity(ownedIdentityId, false);
    }

    private List<Discussion> getDiscussionsAssociatedToIdentity(Id<OwnedIdentity> ownedIdentityId, boolean getHidden) {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            ObvWhere where = discussionQB.where();
            if (getHidden) {
                where.eq(Discussion.FK_OWNED_IDENTITY, ownedIdentityId);
            } else {
                where.eq(Discussion.FK_OWNED_IDENTITY, ownedIdentityId).and().ne(Discussion.STATUS, DiscussionGenerated.Status.HIDDEN);
            }
            discussionQB.selectColumns(Discussion.GEN_ID);
            discussionQB.orderBy(Discussion.SORT_TIMESTAMP, false);
            return discussionQB.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionsAssociatedToIdentity: Unable to query", sqlException);
            return null;
        }
    }

    public List<Id<Discussion>> getContactOrGroupDiscussions(Id<OwnedIdentity> ownedIdentityId) {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            ObvWhere where = discussionQB.where();
            where.and(where.eq(Discussion.FK_OWNED_IDENTITY, ownedIdentityId), where.or(where.isNotNull(Discussion.FK_CONTACT), where.isNotNull(Discussion.FK_GROUP)));
            discussionQB.selectColumns(Discussion.GEN_ID);
            discussionQB.orderBy(Discussion.SORT_TIMESTAMP, false);
            return discussionQB.query().stream().map(AbstractTableGenerated::getItemId).toList();
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionsAssociatedToIdentity: Unable to query", sqlException);
            return null;
        }
    }

    public Discussion getDiscussionByContactId(Id<Contact> contactId) {
        this.checkThread();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            discussionQB.where().eq(Discussion.FK_CONTACT, contactId);
            return (Discussion)discussionQB.queryForFirst();
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByContact: Unable to query: " + String.valueOf(contactId));
            return null;
        }
    }

    public Discussion getDiscussionFromGroupIdentifier(byte[] bytesGroupUidAndOwnerIdentity, Id<OwnedIdentity> ownedIdentity) {
        this.checkThread();
        if (bytesGroupUidAndOwnerIdentity == null || ownedIdentity == null) {
            this.logger.error("getDiscussionByGroupUidAndOwnedIdentity: invalid params");
            return null;
        }
        ObvQueryBuilder groupQB = DbManager.getInstance().getGroupDao().queryBuilder();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            discussionQB.where().eq(Discussion.FK_OWNED_IDENTITY, ownedIdentity);
            groupQB.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupUidAndOwnerIdentity);
            discussionQB.join(Discussion.FK_GROUP, Group.GEN_ID, groupQB);
            return (Discussion)this.queryForFirst(discussionQB.prepare());
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByGroupUidAndOwnedIdentity: Unable to query", sqlException);
            return null;
        }
    }

    public Optional<? extends AbstractMessageGenerated<?>> getLastMessage(Discussion discussion) {
        Optional<Id<SystemMessage>> lastSystemMessageId;
        this.checkThread();
        Optional<Id<MessageRef>> lastUserMessageRefId = discussion.getLastUserMessageRefId();
        if (lastUserMessageRefId.isPresent()) {
            MessageRef messageRef = DbManager.getInstance().getMessageRefDao().get(lastUserMessageRefId.get());
            switch (messageRef.getKind()) {
                case NOT_RECEIVED: 
                case DELETED: {
                    return Optional.empty();
                }
                case INBOUND: {
                    return Optional.ofNullable(DbManager.getInstance().getInboundMessageDao().get(messageRef.getInboundMessageId().get()));
                }
                case OUTBOUND: {
                    return Optional.ofNullable(DbManager.getInstance().getOutboundMessageDao().get(messageRef.getOutboundMessageId().get()));
                }
                case OWNED: {
                    return Optional.ofNullable(DbManager.getInstance().getOwnedMessageDao().get(messageRef.getOwnedMessageId().get()));
                }
            }
        }
        if ((lastSystemMessageId = discussion.getLastSystemMessageId()).isPresent()) {
            return Optional.ofNullable(DbManager.getInstance().getSystemMessageDao().get(lastSystemMessageId.get()));
        }
        return Optional.empty();
    }

    public Optional<? extends AbstractMessageGenerated<?>> computeLastMessage(Discussion discussion, boolean withDrafts) {
        this.checkThread();
        ArrayList allLastMessages = new ArrayList();
        if (withDrafts) {
            DbManager.getInstance().getOutboundMessageDao().getLastMessageForDiscussion(discussion).ifPresent(allLastMessages::add);
        } else {
            DbManager.getInstance().getOutboundMessageDao().getLastMessageForDiscussionWithoutDraft(discussion).ifPresent(allLastMessages::add);
        }
        DbManager.getInstance().getInboundMessageDao().getLastMessageForDiscussion(discussion).ifPresent(allLastMessages::add);
        DbManager.getInstance().getOwnedMessageDao().getLastMessageForDiscussion(discussion).ifPresent(allLastMessages::add);
        DbManager.getInstance().getSystemMessageDao().getLastMessageForDiscussion(discussion).ifPresent(allLastMessages::add);
        return allLastMessages.stream().max(Comparator.comparingDouble(AbstractMessageGenerated::getSortIndex));
    }

    public Optional<Discussion> getByGroupIdentifierWithAnyStatus(Id<OwnedIdentity> ownedIdentityId, byte[] bytesGroupIdentifier) {
        this.checkThread();
        if (ownedIdentityId == null || bytesGroupIdentifier == null) {
            this.logger.error("getByGroupIdentifierWithAnyStatus: invalid params");
            return Optional.empty();
        }
        ObvQueryBuilder groupQB = DbManager.getInstance().getGroupDao().queryBuilder();
        ObvQueryBuilder discussionQB = this.queryBuilder();
        try {
            discussionQB.where().eq(Discussion.FK_OWNED_IDENTITY, ownedIdentityId);
            groupQB.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupIdentifier);
            discussionQB.join(Discussion.FK_GROUP, Group.GEN_ID, groupQB);
            return Optional.ofNullable((Discussion)discussionQB.queryForFirst());
        }
        catch (SQLException sqlException) {
            this.logger.error("getDiscussionByGroupUidAndOwnedIdentity: Unable to query", sqlException);
            return Optional.empty();
        }
    }
}

